# -*- coding: utf-8 -*-

from datetime import datetime, timedelta, time

from stationschedule import station_schedule

from travel.rasp.morda.morda.views.station.utils import smart_sort, Span, SpanLink, awaps_params
from travel.rasp.morda.morda.views.teasers import TeaserSetMorda
from travel.rasp.morda.morda.templates.station.plane import Template as PlaneScheduleTemplate


def plane_schedule(request, context, station, today, event):
    now = request.now

    spans = Span.get_spans()
    current_span = Span.get_span_choice(request, spans, default='day')

    context['date_links'] = SpanLink.date_links(request, spans, current_span=current_span)

    window = (None, None)

    if current_span.code in ['day', 'tomorrow']:
        context['date'], window = get_date_and_window_by_span(station, now, current_span.code)

    schedule = station_schedule(station, event=event, t_type_code='plane',
                                start_datetime_limit=window[0], end_datetime_limit=window[1])

    if current_span.code == 'day':
        for route in schedule.schedule:
            # скрываем ушедшие и прибывшие рейсы
            route.hidden = route.event_dt < now

    context['schedule'] = schedule.schedule
    context['span'] = current_span.code

    smart_sort(context)

    context['teasers'] = TeaserSetMorda(request, 'tablo', (context['station'], context['schedule']))
    context['awaps_params'] = awaps_params('tablo', station, context.get('date'))

    return PlaneScheduleTemplate.render(request, context)


def get_date_and_window_by_span(station, now, span, hours_after_midnight=4):
    if span not in ['day', 'tomorrow']:
        raise ValueError

    # По местной дате
    local_today = station.local_time(now).date()

    local_date = local_today if span == 'day' else local_today + timedelta(days=1)

    # По местной дате
    local_today = station.local_time(now).date()

    local_date = local_today if span == 'day' else local_today + timedelta(days=1)

    window_start = datetime.combine(local_date, time(0, 0))
    window_end = datetime.combine(local_date + timedelta(days=1),
                                  time(hours_after_midnight, 0))
    window_end += timedelta(minutes=-1)

    return local_date, (window_start, window_end)
