# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import datetime, time, timedelta

from common.utils.date import astimezone, timedelta2hours
from common.utils.locations import change_params


LEFT_HOURS = 16  # Сколько часов предыдущего дня отображается на линейке
RIGHT_HOURS = 12
HOUR_SIZE = 8.0 / 4  # Размер одного часа на линейке в процентах


def slider(request, station, terminal, event, msk_tablo_datetime, select_limit, time_zone):
    msk_current = msk_tablo_datetime.replace(minute=0, second=0, microsecond=0)

    # Время в табло по выбранной временной зоне
    current = station.get_local_datetime(msk_current)

    slider_size = select_limit.days * 24 + (select_limit.seconds + 3600 - 1) / 3600  # в часах, деление секунд - ceil division

    slider_left = current
    slider_right = slider_left + timedelta(hours=slider_size)

    now = request.now

    # current_day, prev_day, next_day - нужны для отображения шкалы, берем местное время
    # Если есть переданное значение scaleLeft - левая граница шкалы, то используем его -
    # дабы шкала не прыгала почем зря

    try:
        scale_left = datetime.strptime(request.GET.get('scaleLeft', '').split('.')[0], '%Y-%m-%dT%H:%M:%S')

    except ValueError:
        scale_left = None

    local_now = station.get_local_datetime(now)

    if scale_left:
        current_day_start = station.pytz.localize(scale_left + timedelta(hours=LEFT_HOURS))

    else:
        current_day_start = station.get_local_datetime(msk_current)

    current_day_start = current_day_start.replace(hour=0, minute=0, second=0, microsecond=0)

    while current_day_start + timedelta(days=1, hours=RIGHT_HOURS - 4) < slider_right:
        current_day_start += timedelta(days=1)

    while current_day_start - timedelta(hours=LEFT_HOURS - 4) > slider_left:
        current_day_start -= timedelta(days=1)

    current_day = current_day_start.date()

    # Вычисления для ссылок на следующие дни
    tz_today = astimezone(local_now, time_zone).date()

    delta_day = (current.date() - tz_today).days

    links = []

    for d in [-1, 0, 1]:
        start = datetime.combine(tz_today + timedelta(days=d), current.time())

        links.append(change_params(request.GET, {'start': start.strftime('%Y-%m-%dT%H:%M:00'),
                                                  'span': slider_size}))

    scale_start = datetime.combine(current_day, time(0, 0)) - timedelta(hours=LEFT_HOURS)

    data = {
        'time_zone': station.pytz,
        'current': current,
        'limits': [
            station.get_local_datetime(datetime.combine(current.date() - timedelta(days=1), time(0, 0))),
            station.get_local_datetime(datetime.combine(current.date() + timedelta(days=2), time(0, 0))),
        ],
        'span': slider_size,
        'position': timedelta2hours(current.replace(tzinfo=None) - scale_start) * HOUR_SIZE,  # Позиция первой рамки слайдера
        'width': slider_size * HOUR_SIZE,  # Длина слайдера
        'start': scale_start,
        'now': local_now,
        'day': delta_day,
        'links': links,
    }

    prev_day = current_day - timedelta(1)
    next_day = current_day + timedelta(1)
    hours = (
        ('12:00', prev_day),
        ('16:00', None),
        ('20:00', None),
        ('00:00', current_day),
        ('04:00', None),
        ('08:00', None),
        ('12:00', None),
        ('16:00', None),
        ('20:00', None),
        ('00:00', next_day),
        ('04:00', None),
        ('08:00', None),
    )

    data['scale'] = zip(hours, xrange(12))

    return data
