# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from stationschedule.views import station_schedule

from travel.rasp.morda.morda.templates.station.train import Template
from travel.rasp.morda.morda.views.station.utils import smart_sort, get_schedule_date_by_span, fill_spans_context, awaps_params
from travel.rasp.morda.morda.views.teasers import TeaserSetMorda


def train(request, context, station, today, event):
    # Сначала получаем расписание на все дни
    default_span = 'schedule' if request.NATIONAL_VERSION == 'tr' else 'day'

    current_span = fill_spans_context(request, station, context, default_span_code=default_span)

    local_date = get_schedule_date_by_span(request, station, current_span)
    if local_date:
        context['date'] = local_date

    context['schedule'] = station_schedule(station, event=event, schedule_date=local_date,
                                           t_type_code='train').schedule_routes

    smart_sort(context)

    context['teasers'] = TeaserSetMorda(request, 'tablo', (context['station'], context['schedule']))
    context['awaps_params'] = awaps_params('tablo', station, context.get('date'))

    return Template.render(request, context)
