# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import calendar

from django.http import HttpResponse

from travel.rasp.library.python.common23.date import environment
from common.utils.date import timedelta2minutes


def correction(request):
    utc_now = environment.now_utc(aware=True)
    tz_offset = utc_now.astimezone(request.client_city.pytz).utcoffset()

    script = 'window.timeCorrection = %.1f - new Date().getTime() / 1000; window.timeZOffset = %s' % \
        (calendar.timegm(utc_now.timetuple()), timedelta2minutes(tz_offset))

    return HttpResponse(script, content_type='text/javascript')
