# -*- coding: utf-8 -*-
# Django settings for morda project.

from common.settings import *
from mapping.settings import *
from travel.rasp.morda.morda.tariffs.settings import *
from url_mapper.settings import *


STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'

TEMPLATES = [
    # тут могут быть использованы и другие бэкенды,
    # ...
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': False,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    }
]

DEBUG = False
TEMPLATE_DEBUG = DEBUG
ENABLE_ANTIROBOT = False


SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale.
USE_L10N = True

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = False

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = '//yastat.net/s3/rasp/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'e)q36xhlc$c$50c$nbre^8^55hb=7l1q57+h63dme^g*&amp;j8=)n'


def context_extractor(request):
    return {
        'user_rid': request.GET.get('_rid', ''),
        'service_rid': request.META.get('HTTP_X_REQUEST_ID', '')
    }


PYLOGCTX_REQUEST_EXTRACTOR = context_extractor


MIDDLEWARE_CLASSES = (
    'common.middleware.extract_context.ExtractRequestMiddleware',
    'common.middleware.ping.PingResponder',

    'django.middleware.common.CommonMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',

    'common.middleware.now.Now',
    'common.middleware.syncdb.SyncDB',
    'common.middleware.request_activator.RequestActivator',
    'common.middleware.robot_detector.RobotDetector',
    'common.middleware.host.Host',
    'common.middleware.uatraits_detector.UatraitsDetectorMiddleware',
    'common.middleware.locale_request.Locale',
    'travel.rasp.morda.morda.middleware.metrika.Metrika',
    'common.geotargeting.middleware.GeoTargeting',
    'common.middleware.blackbox_session.BlackboxSessionMiddleware',
    'common.middleware.yandexuid.YandexuidMiddleware',
    'common.middleware.yauser.YaUserMiddleware',
    'travel.rasp.morda.morda.middleware.mobileredirect.MobileRedirect',
    'common.middleware.language.LanguageMiddleware',
)

ROOT_URLCONF = 'travel.rasp.morda.morda.urls'


ALLOWED_HOSTS = ['*']


INSTALLED_APPS = [
    # 'django_tune',
    # Сторонние приложения
    'pytils',
    'raven.contrib.django.raven_compat',
    # Локальные приложения
] + COMMON_INSTALLED_APPS + [
    # Чтобы работали переопределения шаблонов, django нужно включать позже
    'django.contrib.sites',
    'django.contrib.auth',
    'django.contrib.contenttypes',

    'geosearch',
    'travel.rasp.morda.morda',
    'route_search',
    'stationschedule',
    'mapping'
]

CACHEROOT = '/rasp/morda/'

MARKUP_ROOT = os.getenv('RASP_MORDA_MARKUP_ROOT', os.path.join(os.path.dirname(__file__), 'morda/markup'))
PAGE_ROOT = os.path.join(MARKUP_ROOT, 'pages-desktop')
try:
    with open('{}/version'.format(MARKUP_ROOT), 'r') as f:
        version = f.readline().strip()
        MARKUP_URL = 'https://yastat.net/s3/rasp/s/morda/%s/' % version
except Exception:
    import traceback
    print('Error while reading version', traceback.format_exc())
    MARKUP_URL = '//yandex.st/rasp/%s/' % PKG_VERSION

PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), ''))
EXPORT_PATH = os.path.join(PROJECT_PATH, 'export')

# Настройка тикетов
CHECK_IS_USER_VALID = True
IGNORE_DAEMON_CACHE = False
TICKET_NATIONAL_VERSIONS = ('ru', 'ua')

SUGGEST_URL = ''
SUGGEST_POINTS_LIMIT = 100

TINYURL = 'http://tinyurl-test.yandex.ru/tiny'

try:
    SUBMODULE_STATUS = open(
        os.path.join(os.path.dirname(__file__), '', 'submodule-status')
    ).read()
except IOError:
    SUBMODULE_STATUS = None


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = [
    'geosearch.models:DefaultPoint.objects.precache',
    'common.models.geo:Station.precache_sample_titles',
    'mapping.models:RouteMapBlacklist.precache_numbers',
    'common.models.tariffs:NotTariffTrain.precache_numbers',
    'mapping.drawers:TrainPathDrawer.storage.preload',
    'mapping.drawers:LimePathDrawer.storage.preload',
] + with_suffix('.objects.precache', [
    'common.models.geo:StationType',
    'common.models.geo:StationMajority',
    'common.models.transport:TransportType',
    'common.models.transport:TransportModel',
    'common.models.geo:Country',
    'common.models.geo:Region',
    'common.models.geo:Settlement',
    'common.models.geo:StationTerminal',
    'common.models.schedule:RThreadType',
    'common.models.geo:Direction',
    'common.models.geo:ExternalDirection',
    'common.models.tariffs:SuburbanTariff',
    'common.models.tariffs:TariffType',
    'common.models.schedule:Company',
    'common.models.geo:CodeSystem',
    'common.models.tariffs:Setting',
    'common.models.schedule:PlatformTranslation',
    'common.models.geo:DirectionTranslate',
    'common.models.geo:DirectionFromTranslate',
])

# TODO: хак, должно использоваться только в api демона кб
PARTNERS_DONT_QUERY_TODAY = ['tripsta', 'amargo', 'biletix', 'biletexpert']

SEARCH_LOG = 'log/search.log'
REDIR_LOG = 'log/order/redir.log'
PLANE_REDIR_LOG = 'log/order/plane_redir.log'
BUS_REDIR_LOG = 'log/order/bus_redir.log'
AUCTION_REDIR_LOG = 'log/order/auction_redir.log'
RASP_USERS_SEARCH_LOG = 'log/yt/search.log'

LOGTAIL_AVAILABLE_LOGS = dict()

XGETTEXT_BEM_BLOCKS = [
    # (path, prefix, blocks)
    (
        ['morda', 'markup', 'blocks-desktop'],
        'blocks-desktop',
        [
            'b-currency',
            'b-form',
            'b-form-input',
            'b-map',
            'b-maps-search',
            'b-rasp-search',
            'b-sch-print',
            'b-timetable',
            'b-blablacar',
            'i-time'
        ]
    ),
]

XGETTEXT_KEYSETS.update({
    'morda': {
        'filename': 'morda/keyset.json',
        'dirs': [
            'morda',
        ]
    }
})

PATHFINDDER_DATA_PATH = None
GEOMETRY_BASE_PATH = '/var/lib/yandex-rasp-morda/geometry'

ENABLE_TOUCH_REDIRECT = True

DOMAIN_TO_TOUCH_NATIONAL_VERSION = {
    'ru': 't.rasp.yandex.ru',
    'ua': 't.rasp.yandex.ua'
}

TOUCH_DOMAIN = DOMAIN_TO_TOUCH_NATIONAL_VERSION['ru']

DEFAULT_METRIKA = 99704

SUPPORTED_HOSTS = []

# RASPFRONT-1958 используется для запросов к ticketdaemon
PROJECT_CODE = 'rasp_morda'


# RASPFRONT-7713
REMOTE_ADDR_META_VARIABLE = 'HTTP_X_RASP_REAL_IP'
REMOTE_ADDR_META_VARIABLE_FALLBACK = 'HTTP_X_REAL_IP'
