# -*- coding: utf-8 -*-
from math import ceil

from common.utils.locations import composeurl


def divide_list(l, pieces=3):
    """ Разделяет список на несколько с примерно одинаковым количеством элементов """
    part = int(ceil(float(len(l)) / pieces))
    for i in xrange(pieces):
        yield l[part*i:part*(i+1)]


def get_tablo_url(station, event='departure'):
    if event == 'departure':
        return composeurl('station', args=[station.id])
    elif event == 'arrival':
        return composeurl('station', args=[station.id], params={'event': event})
    else:
        raise ValueError('Event must be one of [departure, arrival]')
