PY2_LIBRARY(morda)

OWNER(lorekhov)

PEERDIR(
    metrika/uatraits/python

    contrib/python/ipython
    travel/library/python/entrypoint

    travel/library/python/resource

    travel/rasp/library/python/common
    travel/rasp/library/python/common_old
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/mapping
    travel/rasp/library/python/route_search
    travel/rasp/library/python/stationschedule
    travel/rasp/library/python/url_mapper
    travel/rasp/library/python/hemi
)

PY_SRCS(
    TOP_LEVEL
    docker/local_settings.py
    gunicorn_conf.py
    settings.py
)

PY_SRCS(
    morda/__init__.py
    morda/app.py
    morda/forms.py
    morda/informers/__init__.py
    morda/informers/forms.py
    morda/informers/urls.py
    morda/informers/views.py
    morda/management/__init__.py
    morda/management/commands/__init__.py
    morda/management/commands/update_date_validator_js.py
    morda/middleware/__init__.py
    morda/middleware/metrika.py
    morda/middleware/mobileredirect.py
    morda/models/__init__.py
    morda/models/mapping.py
    morda/order/__init__.py
    morda/order/forms.py
    morda/order/models/__init__.py
    morda/order/models/coach.py
    morda/order/models/coachschema.py
    morda/order/models/coachservice.py
    morda/order/urls.py
    morda/order/utils.py
    morda/order/views/__init__.py
    morda/order/views/bus.py
    morda/order/views/bus_redirect.py
    morda/order/views/form.py
    morda/order/views/partners/__init__.py
    morda/order/views/partners/allticketsfor_me.py
    morda/order/views/partners/avperm.py
    morda/order/views/partners/donavto.py
    morda/order/views/partners/e_traffic.py
    morda/order/views/partners/ecolines.py
    morda/order/views/partners/infobus.py
    morda/order/views/partners/kamilkoc.py
    morda/order/views/partners/kvc_tula.py
    morda/order/views/partners/main.py
    morda/order/views/partners/mrtrans.py
    morda/order/views/partners/neoplan_trans_tur.py
    morda/order/views/partners/pamukkale.py
    morda/order/views/partners/pavlodar.py
    morda/order/views/partners/takebus.py
    morda/order/views/partners/udmbus.py
    morda/order/views/partners/unistation.py
    morda/order/views/partners/unitiki.py
    morda/order/views/partners/utils.py
    morda/order/views/partners/utisauto.py
    morda/order/views/redirect.py
    morda/order/views/train/__init__.py
    morda/order/views/train/base.py
    morda/order/views/train/ufs.py
    morda/order/views/train/ukrmintrans.py
    morda/redirects/__init__.py
    morda/redirects/urls.py
    morda/redirects/views.py
    morda/tariffs/__init__.py
    morda/tariffs/bus.py
    morda/tariffs/retrieving/__init__.py
    morda/tariffs/retrieving/base.py
    morda/tariffs/retrieving/mobiticket.py
    morda/tariffs/retrieving/tickets_ua.py
    morda/tariffs/retrieving/ufs.py
    morda/tariffs/settings.py
    morda/tariffs/utils.py
    morda/tariffs/views.py
    morda/templates/__init__.py
    morda/templates/base.py
    morda/templates/choose_airport.py
    morda/templates/choose_points.py
    morda/templates/city.py
    morda/templates/direction_map.py
    morda/templates/error.py
    morda/templates/filters.py
    morda/templates/form.py
    morda/templates/informers.py
    morda/templates/iwidgets.py
    morda/templates/maps/__init__.py
    morda/templates/maps/air.py
    morda/templates/maps/base.py
    morda/templates/maps/buses.py
    morda/templates/maps/compact/__init__.py
    morda/templates/maps/compact/air.py
    morda/templates/maps/compact/trains.py
    morda/templates/maps/trains.py
    morda/templates/order/__init__.py
    morda/templates/order/error.py
    morda/templates/order/i18n.py
    morda/templates/order/train.py
    morda/templates/order/universal.py
    morda/templates/partners.py
    morda/templates/print_schedule/__init__.py
    morda/templates/print_schedule/hyphenize.py
    morda/templates/print_schedule/print_result.py
    morda/templates/print_schedule/print_settings.py
    morda/templates/search.py
    morda/templates/small_description.py
    morda/templates/sort.py
    morda/templates/static.py
    morda/templates/station/__init__.py
    morda/templates/station/base.py
    morda/templates/station/hidden.py
    morda/templates/station/plane.py
    morda/templates/station/schedule.py
    morda/templates/station/schedule_bus_block.py
    morda/templates/station/sea.py
    morda/templates/station/suburban.py
    morda/templates/station/tablo.py
    morda/templates/station/train.py
    morda/templates/station_info.py
    morda/templates/station_search.py
    morda/templates/teasers.py
    morda/templates/thread/__init__.py
    morda/templates/thread/base.py
    morda/templates/thread/trip.py
    morda/templates/thread/trip_bus.py
    morda/templates/thread/trip_interval.py
    morda/templates/thread_search.py
    morda/templates/timetable.py
    morda/templates/utils.py
    morda/urls.py
    morda/utils/__init__.py
    morda/utils/domodevo_news.py
    morda/utils/locations.py
    morda/utils/suggests.py
    morda/utils/tinyurl.py
    morda/views/__init__.py
    morda/views/city/__init__.py
    morda/views/city/prefill.py
    morda/views/city/promo.py
    morda/views/direction.py
    morda/views/errors.py
    morda/views/logtail.py
    morda/views/mapping/__init__.py
    morda/views/mapping/flights.py
    morda/views/mapping/objects.py
    morda/views/mapping/suggests/__init__.py
    morda/views/mapping/suggests/flights.py
    morda/views/mapping/suggests/livemap.py
    morda/views/mapping/suggests/utils.py
    morda/views/print_schedule.py
    morda/views/samples.py
    morda/views/search/__init__.py
    morda/views/search/airports.py
    morda/views/search/backends.py
    morda/views/search/banners.py
    morda/views/search/counters.py
    morda/views/search/filters.py
    morda/views/search/hints.py
    morda/views/search/schedule.py
    morda/views/search/search.py
    morda/views/search/tariffs.py
    morda/views/search/teasers.py
    morda/views/search/title.py
    morda/views/search/validate.py
    morda/views/station/__init__.py
    morda/views/station/common_schedule.py
    morda/views/station/locations.py
    morda/views/station/plane.py
    morda/views/station/schedule.py
    morda/views/station/slider.py
    morda/views/station/suburban.py
    morda/views/station/tablo.py
    morda/views/station/title.py
    morda/views/station/train.py
    morda/views/station/utils.py
    morda/views/station_search.py
    morda/views/suburbanwizard.py
    morda/views/teasers.py
    morda/views/thread.py
    morda/views/thread_search.py
    morda/views/timecorrection.py
    morda/views/tinyurl.py
    morda/views/version.py
    morda/wsgi.py
    staticpages/__init__.py
    staticpages/urls.py
    staticpages/utils.py
    staticpages/views.py
)

RESOURCE_FILES(
    morda/keyset.json
)

END()

RECURSE(
    bin
    markup_package
)

RECURSE_FOR_TESTS(
    bin/tests
)
