#!/usr/bin/env python2
# -*- coding: utf-8 -*-

import os
import re
import shutil
import subprocess
import sys

MARKUP_SUBMODULE = 'morda/markup'
SUBMODULE_HASH_PATTERN = re.compile(r' (.+?) ')


def get_submodule_hash(submodule_path):
    submodule_status = subprocess.check_output(
        ['git', 'submodule', 'status', submodule_path]
    )

    match = SUBMODULE_HASH_PATTERN.match(submodule_status)

    assert match, "Invalid status of markup submodule: %r" % submodule_status

    return match.group(1)


def main():
    target_folder = sys.argv[1]

    assert not os.path.exists(target_folder), "Target folder already exists"

    markup_hash = get_submodule_hash(MARKUP_SUBMODULE)

    subprocess.check_call(
        ['git', 'checkout', '--quiet', 'build-%s' % markup_hash],
        cwd=MARKUP_SUBMODULE
    )
    try:
        subprocess.check_call(
            ['debian/tools/copyrepo.py', MARKUP_SUBMODULE, target_folder,
             '--subpath', 'debian/markup-built']
        )
        shutil.copy(
            os.path.join(MARKUP_SUBMODULE, 'debian/markup-version'),
            target_folder
        )

    finally:
        subprocess.check_call(
            ['git', 'submodule', 'update', '--quiet', MARKUP_SUBMODULE]
        )

if __name__ == '__main__':
    main()
