# -*- coding: utf-8 -*-

from settings import *
from common.settings.configuration import Configuration
from common.settings.utils import get_base_domain
from common.settings.utils import use_master_only

PACKAGE_NAME = '@@PACKAGE_NAME@@'
BASE_PACKAGE_NAME = PUBLIC_PACKAGE_NAME = 'yandex-rasp-morda'

if PACKAGE_NAME == 'yandex-rasp-morda-service':
    INSTANCE_ROLE = ServiceInstance
elif PACKAGE_NAME == 'yandex-rasp-morda-migration':
    INSTANCE_ROLE = MigrationInstance


if PACKAGE_NAME in (
    BASE_PACKAGE_NAME + '-admin',
    BASE_PACKAGE_NAME + '-service',
    BASE_PACKAGE_NAME + '-migration'
):
    use_master_db = True
    PRECACHE = []
else:
    use_master_db = False

ENABLE_PROD_NEW_MAINTENANCE = True

Configuration().apply(globals())

if use_master_db:
    use_master_only(globals())

pkg_version = '@@PKG_VERSION@@'

if pkg_version != '@@' + 'PKG_VERSION' + '@@':
    PKG_VERSION = pkg_version

CACHEROOT = '/%s/%s/' % (PACKAGE_NAME, PKG_VERSION)

MARKUP_URL = '//yandex.st/rasp/@@MARKUP_VERSION@@/'

MEDIA_ROOT = '/var/lib/yandex-rasp-morda/media/'
if PACKAGE_NAME == 'yandex-rasp-morda-admin':
    MEDIA_ROOT = '/var/lib/yandex-rasp/rasp/media/'
elif PACKAGE_NAME == 'yandex-rasp-morda-service':
    MEDIA_ROOT = '/var/lib/yandex-rasp-service/rasp/media/'
elif PACKAGE_NAME == 'yandex-rasp-morda-migration':
    MEDIA_ROOT = '/var/lib/yandex-rasp-migration/rasp/media/'


admin_host = 'admin.rasp.yandex-team.ru'


ADMINS = (('Rasp Testing', 'rasp-testing@yandex-team.ru'), )

TREE_LOG_LEVEL = 'INFO'

ENABLE_ANTIROBOT = True

if YANDEX_ENVIRONMENT_TYPE == 'production':
    TINYURL = 'http://tinyurl.yandex.net/tiny'
    MEDIA_URL = '//yastat.net/s3/rasp/media/'
    SUGGEST_URL = '//suggests.rasp.yandex.net/'
    TICKETS_QUERY_URL = 'http://daemon.avia.yandex.net/api/1.0/'

    SUPPORTED_HOSTS = [
        'rasp.yandex.%s' % tld
        for tld in ['ru', 'ua', 'kz', 'uz', 'by']
    ] + ['rasp.ya.ru']

    ADMINS = (('Rasp Testing', 'rasp-errors@yandex-team.ru'), )

    RAVEN_CONFIG = {
        'transport': 'raven.transport.requests.RequestsHTTPTransport',
        'dsn':
            'https://1bcfcc478c8d49bfb231451574ce29e8:c2ca8d35cb3d4ae9b93fd0583e79a0c9'
            '@production.sentry.rasp.common.yandex.net/43'
            '?ca_certs={}'.format(REQUESTS_CA_BUNDLE),
    }

elif YANDEX_ENVIRONMENT_TYPE == 'testing':
    TREE_LOG_LEVEL = 'DEBUG'
    admin_host = 'admin-test.rasp.yandex-team.ru'
    MEDIA_URL = '//rasp.%s/media/' % admin_host

    RAVEN_CONFIG = {
        'transport': 'raven.transport.requests.RequestsHTTPTransport',
        'dsn':
            'https://131fbab6e8334ad9834b616b7cb7e808:1a822123e3f745c4bb58de97bdef10bc'
            '@testing.sentry.rasp.common.yandex.net/47'
            '?ca_certs={}'.format(REQUESTS_CA_BUNDLE),
    }

    SUGGEST_URL = '//suggests.tst.rasp.yandex.net/'

elif YANDEX_ENVIRONMENT_TYPE == 'stress':
    TREE_LOG_LEVEL = 'DEBUG'
    emulator_host = 'target152g.load.yandex.net'

    # Настройки тарифов
    ASK_UFS = True
    UFS_HOST = emulator_host + ':8080'
    UFS_TRAINLIST = '/ufs/trainlist'
    UFS_CARSLISTEX = '/ufs/carslistex'
    UFS_SSL = False
    ASK_TICKETS_UA = True
    TICKETS_UA_TRAIN_URL = 'http://%s:8080/tickets_ua' % emulator_host
    UFS_PLANE_URL = "http://%s:8080/ufs" % emulator_host
    UKRMINTRANS_HOST = "http://%s:8080/ukrmintrans" % emulator_host

    TINYURL = 'http://%s/tinyurl.xml' % emulator_host

    ENABLE_ANTIROBOT = False

    SUGGEST_URL = '//suggests.load.rasp.yandex.net/'

if YANDEX_ENVIRONMENT_TYPE in ['stress', 'testing']:
    base_domain = get_base_domain(YANDEX_ENVIRONMENT_TYPE, YANDEX_ENVIRONMENT_NAME)

    admin_host = '%s.yandex-team.ru' % base_domain

    DOMAIN_NAME = 'rasp.%s.yandex.ru' % base_domain
    TICKET_HOST = 'travel-test.yandex.ru/avia'

    DOMAIN_TO_TOUCH_NATIONAL_VERSION = {
        'ru': 't.rasp.%s.yandex.ru' % base_domain,
        'ua': 't.rasp.%s.yandex.ua' % base_domain
    }

    TOUCH_DOMAIN = DOMAIN_TO_TOUCH_NATIONAL_VERSION['ru']

    if YANDEX_ENVIRONMENT_NAME == 'localhost':
        SUGGEST_URL = '//suggests.rasp.yandex.net/'

    SUPPORTED_HOSTS = [
        'rasp.%s.yandex.%s' % (base_domain, tld)
        for tld in ['ru', 'ua', 'kz', 'uz', 'by']
    ]


EXPORT_PATH = '/var/lib/yandex-rasp-morda/export'

PATHFINDDER_DATA_PATH = '/var/lib/yandex-rasp-pathfinder/data'

LOG_PATH = '/var/log/' + PACKAGE_NAME


if PACKAGE_NAME == BASE_PACKAGE_NAME + '-admin':
    TREE_LOG_LEVEL = 'DEBUG'
    ADMIN_LINK = 'https://rasp.%s' % admin_host
    MEDIA_URL = '//rasp.%s/media/' % admin_host

    EXPORT_PATH = '/var/lib/yandex-rasp/rasp/www/db/scripts/export'

    PATHFINDDER_DATA_PATH = '/var/lib/yandex-rasp/rasp/www/db/scripts/data/pathfinder'

if PACKAGE_NAME == BASE_PACKAGE_NAME + '-service':
    TREE_LOG_LEVEL = 'DEBUG'
    ADMIN_LINK = 'https://rasp-service.%s' % admin_host
    MEDIA_URL = '//rasp-service.%s/media/' % admin_host

    EXPORT_PATH = '/var/lib/yandex-rasp-service/rasp/www/db/scripts/export'

    PATHFINDDER_DATA_PATH = '/var/lib/yandex-rasp-service/rasp/www/db/scripts/data/pathfinder'

if PACKAGE_NAME == BASE_PACKAGE_NAME + '-migration':
    TREE_LOG_LEVEL = 'DEBUG'
    ADMIN_LINK = 'https://rasp-migration.%s' % admin_host
    MEDIA_URL = '//rasp-migration.%s/media/' % admin_host

    EXPORT_PATH = '/var/lib/yandex-rasp-migration/rasp/www/db/scripts/export'

    PATHFINDDER_DATA_PATH = '/var/lib/yandex-rasp-migration/rasp/www/db/scripts/data/pathfinder'

_format = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': _format
        },
        'exception': {
            '()': 'ylog.ExceptionFormatter',
            'format': _format,
        },
        'traceback': {
            '()': 'ylog.ExceptionFormatter',
            'format': _format,
            'full': True,
            'show_locals': True
        },
    },
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'handlers': {
        'tree_handler': {
            'level': 'DEBUG',
            'class': 'travel.rasp.library.python.common23.logging.FileTreeHandler',
            'base_path': LOG_PATH,
            'formatter': 'verbose',
        },
        'exception': {
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'exception.log'),
            'formatter': 'exception',
            'level': 'ERROR',
        },
        'traceback': {
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'traceback.log'),
            'formatter': 'traceback',
            'level': 'ERROR',
        },
    },
    'loggers': {
        '': {
            'handlers': ['tree_handler'],
            'level': TREE_LOG_LEVEL,
        },
        'django': {
            'handlers': ['exception', 'traceback'],
            'level': 'ERROR',
        }
    }
}

SEARCH_LOG = os.path.join(LOG_PATH, 'marketstat/search.log')
REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/redir.log')
PLANE_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/plane_redir.log')
BUS_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/bus_redir.log')
AUCTION_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/auction_redir.log')
RASP_USERS_SEARCH_LOG = os.path.join(LOG_PATH, 'yt/search.log')

LOGTAIL_AVAILABLE_LOGS = {
    'tariffs/express_subst.log': '/var/log/' + PACKAGE_NAME + '/rasp/tariffs/express_subst.log',
    'tickets/unknown_codes.log': '/var/log/yandex-ticket-daemon/ticket_daemon/reference/unknown_codes.log',
}

MANAGERS = ADMINS
PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
ERRORS_RECIPIENTS = PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
EXPERSS_SUBST_RCPNTS = UNKNOWN_CODES_RCPNTS = RASP_FREE_STATIONS_RCPNTS = ADMINS
