#!/bin/bash

set -ex

python -c "print 'morda:Depends= ' + ', '.join(l.strip() for l in open('debian/morda-depends'))"  >> debian/yandex-rasp-morda.substvars
cp debian/yandex-rasp-morda.substvars debian/yandex-rasp-morda-admin.substvars
cp debian/yandex-rasp-morda.substvars debian/yandex-rasp-morda-service.substvars
cp debian/yandex-rasp-morda.substvars debian/yandex-rasp-morda-migration.substvars

pkg_version=$(dpkg-parsechangelog | grep-dctrl -ensVersion .)

morda_package=yandex-rasp-morda
morda_dest=debian/$morda_package

tmp_dest=debian/tmp/tmp_dest
mkdir -p $tmp_dest

debian/tools/copyrepo.py --exclude morda/markup . $tmp_dest

# подключаем собранную вёрстку
debian/get_built_markup.py $tmp_dest/morda/markup
markup_version=$(< $tmp_dest/morda/markup/markup-version)

git submodule -q foreach 'echo $path $(git describe --tags --match package-* --always --dirty)' \
    > $tmp_dest/submodule-status

LD_PRELOAD= $tmp_dest/common/virtualenv-setup.sh

for package in $morda_package $morda_package-admin $morda_package-service $morda_package-migration
do
    dest=debian/$package
    main=/usr/share/$package
    maindest=$dest$main

    install -d $maindest

    cp -aT $tmp_dest $maindest

    $maindest/common/virtualenv-relocate.sh $main/common

    python2 -mcompileall -qx "(gunicorn/workers/_gaiohttp\.py|gevent/_socket3\.py)" "$maindest"

    mkdir -p $dest/etc/nginx/sites-{available,enabled}
    cp debian/$package.nginx $dest/etc/nginx/sites-available/$package
    dh_link -p $package etc/nginx/sites-available/$package etc/nginx/sites-enabled/$package

    mkdir -p $dest/etc/gunicorn/conf-{available,enabled}
    cp debian/$package.gunicorn $dest/etc/gunicorn/conf-available/$package
    dh_link -p $package etc/gunicorn/conf-available/$package etc/gunicorn/conf-enabled/$package

    install -D debian/$package.logrotate $dest/etc/logrotate.d/$package

    install -d -o www-data -g www-data $dest/var/cache/$package
    install -d -o www-data -g www-data $dest/var/log/$package
    install -d -o www-data -g www-data $dest/var/log/$package/marketstat

    install -d -o www-data -g www-data $dest/var/lib/$package/export
    install -d -o www-data -g www-data $dest/var/lib/$package/media
    install -d -o www-data -g www-data $dest/var/lib/$package/media/data
    install -d -o www-data -g www-data $dest/var/lib/$package/media/root
    install -d -o www-data -g www-data $dest/var/lib/$package/geometry

    etc_local_settings_dir=/etc/yandex/$(echo $package | sed -r 's/yandex-//')

    mkdir -p $dest$etc_local_settings_dir
    sed -e "s/@@PKG_VERSION@@/$pkg_version/g" \
        -e "s/@@PACKAGE_NAME@@/$package/g" \
        -e "s/@@MARKUP_VERSION@@/$markup_version/g" \
        debian/local_settings.py > $dest$etc_local_settings_dir/local_settings.py
done

mkdir -p $morda_dest/etc/rsyncd.d
cp debian/$morda_package.rsync $morda_dest/etc/rsyncd.d/$morda_package.conf

install -D debian/$morda_package-http.nginx $morda_dest/etc/nginx/locations/$morda_package-http

# Страницы 500-й ошибки
asset_url=//yandex.st/rasp/$markup_version/
pages=$morda_dest/usr/share/$morda_package/morda/markup/pages-desktop

dest=debian/yandex-rasp-morda-errors
main=/usr/share/yandex-rasp-morda-errors
maindest=$dest$main

install -d $maindest

subst_asset_url() {
    page=$1
    lang=$2

    rm $pages/$page/$page.html

    sed -e "s#_${page}\.\(\([a-z0-9]*\.\)*css\)#${asset_url}pages-desktop/common/_common.\1#g" \
        -e "s#_${page}\.\(\([a-z0-9]*\.\)*js\)#${asset_url}pages-desktop/${page}/_${page}.\1#g" \
        -e "s#[.][.]/[.][.]/#${asset_url}#g" \
        $pages/$page/$page.$lang.html > $maindest/$page.html
}

subst_asset_url error-ru ru
subst_asset_url error-com-tr tr
subst_asset_url error-ua uk

install -D debian/yandex-rasp-morda-errors.nginx  $dest/etc/nginx/locations/yandex-rasp-morda-errors
