# -*- coding: utf-8 -*-

from common.settings.configuration import Configuration
from settings import *

DEBUG = True

DATABASES['default']['HOST'] = 'localhost'
DATABASES['default']['NAME'] = 'rasp'

DATABASES['default']['USER'] = 'root'
DATABASES['default']['PASSWORD'] = ''

TEST_DB_NAME = 'rasp_test'

MAINTENANCE_DB_NAME = None

MARKUP_URL = 'http://static-morda.{user}.yandex-team.ru/'

SUPPORTED_HOSTS = [
    '*'
]

LOG_PATH = os.path.join(os.path.dirname(__file__), 'log')

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'
        },
    },
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'handlers': {
        'tree_handler': {
            'level': 'DEBUG',
            'class': 'travel.rasp.library.python.common23.logging.FileTreeHandler',
            'base_path': os.path.abspath('log'),
            'formatter': 'verbose',
        }
    },
    'loggers': {
        '': {
            'handlers': ['tree_handler'],
            'level': 'DEBUG',
        },
    }
}

SUGGEST_URL = 'http://rasp.dev.yandex.ru:9321/'

DEBUG_BEMJSON = True
INSTANCE_ROLE = ServiceInstance
ORDER_DEBUG = True
Configuration().apply(globals())
# PRECACHE = []
TICKETS_QUERY_URL = ""
