(function () {

BEM.DOM.decl('b-blablacar', {
    onSetMod: {
        js: function () {
            var awapsOptions = this.params.awaps;

            this._awapsManager = {
                _callAwaps: function (url) {
                    if (!url) {
                        return;
                    }

                    var img = document.createElement('img');
                    img.src = url + (url.indexOf('?') >= 0 ? '&' : '?') + '_=' + Math.floor((Math.random() * 100000) + 1);

                    img.className = 'b-blablacar__awaps';
                    document.body.appendChild(img);
                },

                callOnShow: function () {
                    this._callAwaps(awapsOptions.showUrl);
                },

                callOnClick: function () {
                    this._callAwaps(awapsOptions.clickUrl);
                }
            };

            this._metrikaManager = {
                callOnClick: function (elementName) {
                    yaCounterReachGoal('morda_blablacar_' + elementName + '_click');
                },
                callOnShow: function () {
                    yaCounterReachGoal('morda_blablacar_show');
                },
                callOnLoading: function () {
                    yaCounterReachGoal('morda_blablacar_loading');
                }
            };

            var _this = this;

            $(window).on('load', function () {
                _this._metrikaManager.callOnLoading();
            });

            if (this.params.data) {
                this.setData(this.params.data);
            }
        }
    },

    hide: function () {
        this.setMod('loading', 'fail');
    },

    setData: function(data) {
        this.setMod('loading', 'success');

        var _this = this;

        $(window).on('load', function () {
            _this._awapsManager.callOnShow();
            _this._metrikaManager.callOnShow();
        });

        this.findBlockInside('b-spin').delMod('progress');

        this.elem('route').html(data.route);

        this.elem('time').html(data.time);

        this.elem('offers-link').html(BEMHTML.apply({
            block: 'b-link',
            mods: {
                theme: 'gray'
            },
            url: data.url,
            target: '_blank',
            content: data.link_text
        }));

        this.elem('service-link').html(BEMHTML.apply({
            block: 'b-link',
            mods: { theme: 'gray' },
            url: data.url,
            target: '_blank',
            content: 'BlaBlaCar'
        }));

        this.elem('price').html(BEMHTML.apply(data.tariff));

        this._initLinkClicks();
    },

    _initLinkClicks: function () {
        var onclick = function (elementName) {
            this._awapsManager.callOnClick();
            this._metrikaManager.callOnClick(elementName);
        };

        var tariffButton = this.findBlockInside(this.findElem('price'), 'b-form-button');
        tariffButton.on('click', onclick.bind(this, 'price'));

        var links = [
            {elem: 'offers-link', block: 'b-link'},
            {elem: 'service-link', block: 'b-link'}
        ];

        links.forEach(function (clickBlock) {
            var block = this.findBlockInside(this.findElem(clickBlock.elem), clickBlock.block);
            block.domElem.on('click', onclick.bind(this, clickBlock.elem));
        }, this);
    }
});
})();
