(function($){
// Чтобы можно было строить b-link на лету через BEM.HTML.build, описываем блок в нужном формате
BEM.HTML.decl('b-link', {
    onBlock: function(ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'));

        var props = ['title', 'target'], p;
        while(p = props.pop()) ctx.param(p) && (ctx.attr(p, ctx.param(p)));
    }
});

/**
 * Переопределяем функцию рассчета позиционирования, чтобы попап всегда был по центру карты
 */
var MIN_OFFSET = 10;
BEM.DOM.decl({ name : 'b-popupa', modName : 'type', modVal : 'bus-map-intro' }, {
    pos : function() {
        var under = this._getUnder(),
            marginLeft = -under.domElem.outerWidth() / 2,
            marginTop = -under.domElem.outerHeight() / 2,
            windowSize = this.__self.getWindowSize();

        under.show({
            left : windowSize.width < 1000 ? 0: '50%',
            top : '50%',
            marginLeft : windowSize.width < 1000?
                344:
                marginLeft + 117,
            marginTop : windowSize.height / 2 - MIN_OFFSET + marginTop < 0?
                -windowSize.height / 2 + MIN_OFFSET :
                marginTop
        });

        return this;

    }
});

BEM.DOM.decl('b-bus-map', {
    // Текущая точка
    _currentPoint : undefined,

    /*
     * Установить текущую точку
     * @param {domElem} дом нода точки (b-serp-item)
     */
    _setCurrentPoint: function(point){
        this._delCurrentPoint();
        this._currentPoint = point;

        point.setMod('state', 'current');
    },

    /*
     * Удалить текущую точку
     */
    _delCurrentPoint: function(){
        !this._currentPoint || this._currentPoint.delMod('state');
    },

    /**
     * Ссылка на b-page, вызывается много где, поэтому кэшируем
     * @return {Object} b-page
     */
    _bPage: function(){
        return this._bPageElem || this.findBlockOutside('b-page');
    },

    /*
     * Обновить размеры карты
     */
    _updateMapSize: function(){
        var windowSize = BEM.DOM.getWindowSize(),
            pageHeight = parseInt(this._bPage().domElem.height()),
            selfTop = parseInt(this.domElem.offset().top),
            footerHeight = parseInt(this._bPage().findBlockInside('b-foot').domElem.height()),

            mapHeight = (windowSize.height - footerHeight - selfTop - 4) + 'px',
            pointsList = this._bPage().findBlockInside('b-serp-list');

        this.findElem('map').attr('style', 'height: ' + (mapHeight));
        pointsList.domElem.attr('style', 'height: ' + (mapHeight));
    },

    onSetMod: {
        'js': function(){
            var self = this,
                introPopupa = this._bPage().findBlockInside({block: 'b-popupa', modName: 'type', modVal: 'bus-map-intro'});


            // Показать приветственную попапу
            introPopupa.show(self.domElem);

            // Внутри есть кнопка «Понятно», биндим на неё скрытие
            introPopupa.findBlockInside('b-form-button').bindTo('click', function(){
                introPopupa.hide();
            });


            self._updateMapSize();
            self.bindToWin('resize', self._updateMapSize);

            ymaps.ready(function(){
                var map = new ymaps.Map("ymaps-map-container", self.params.map);
                map.controls
                    .add("zoomControl")
                    .add("mapTools");


                // Обрабатываем точки
                var points = self.findBlocksInside('b-serp-item'),
                    pointsCollection = new ymaps.GeoObjectCollection();

                for (var i = 0; i < points.length; i++){

                    // Приходится замыкать, иначе iPlacemark будет всегда указывать на points[points.length - 1]
                    (function(){
                        var iPoint = points[i],
                            iPointTitle = iPoint.findElem('title-link'),

                            // Тайтл фактически копируется из b-serp-item__title, возможно это неправильно
//                            iBalloonContent = [{ elem: 'title',
//                                content: {
//                                    block: 'b-link',
//                                    url: iPointTitle.attr('href'),
//                                    content: iPointTitle.text()
//                                }
//                            }].concat(iPoint.params.balloonContent),

                            iBalloonContent = iPoint.params.balloonContent;

                            // формирование точки на карте
                            var iPlacemark = new ymaps.Placemark(iPoint.params.coords, {
                                iconContent: iPoint.params.index,
                                balloonCloseButton: false,
                                balloonContentBody: BEM.HTML.build({
                                    block: 'b-bus-map-balloon',
                                    content: iBalloonContent
                                })
                            }, {
                                preset: "twirl#lightblueIcon"
                            });

                        // Биндимся на клик в панельке слева
                        iPoint.bindTo('click', function(e){
                            iPlacemark.balloon[iPlacemark.balloon.isOpen() ? 'close': 'open']();

                            e.preventDefault();
                        });

                        iPlacemark.events.add('balloonopen', function(){
                            self._setCurrentPoint(iPoint);
                        });
                        iPlacemark.events.add('balloonclose', function(){
                            self._delCurrentPoint();
                        });

                        pointsCollection.add(iPlacemark);
                    })()
                }

                map.geoObjects.add(pointsCollection);
            });
        }

    }

});

})(jQuery);
