(function() {

function pad(str, width, fill) {
    while(str.length < width) {
        str = fill + str;
    }

    return str;
}

function groupDigits(digits) {
    var smallGroup = digits.substring(0, (digits.length - 1) % 3 + 1),
        groups = [smallGroup];

    for(var i = smallGroup.length; i < digits.length; i += 3) {
        groups.push(digits.substr(i, 3));
    }

    return groups.join(" ");
}

function format(fmt) {

    var values = Array.prototype.slice.call(arguments, 1),
        argIndex = 0;

    return fmt.replace(/%(%|\d*d)/g, function (str, options) {
        if(options == '%') {
            return '%';
        }

        var value = Math.floor(values[argIndex++]),
            width = options.substr(0, options.length - 1);

        if(width.length) {
            var fill = " ";

            if(width.length > 1 && width.charAt(0) == '0') {
                fill = '0';
                width = width.substr(1);
            }

            return pad(String(value), parseInt(width), fill);
        }

        return groupDigits(String(value));
    });

}

BEM.DOM.decl('b-currency', {

    _onChangeCurrency : function() {
        BEM.DOM.update(this.domElem, this.__self.format(this.params));
    }

}, {

    format: function(params) {

        var info = BEM.blocks['i-global'].param('currency'),
            displayedCurrency,
            data,
            displayedValue,
            showCents = params.cents,
            whole, cents,
            unitWrapper = params.unit ? params.unit : '$1',
            wholeWrapper = params.whole ? params.whole : '$1',
            result;

        if(typeof params.currency == 'undefined')
            params.currency = info.base;

        if(info.rates.hasOwnProperty(params.currency)) {
            var baseValue = params.value * info.rates[params.currency];
            displayedCurrency = info.selected;
            displayedValue = baseValue / info.rates[displayedCurrency];
        } else {
            // Currency base rate unavailable, cannot convert, displaying native value
            displayedCurrency = params.currency;
            displayedValue = params.value;
        }

        whole = Math.floor(displayedValue);
        cents = Math.round((displayedValue - whole) * 100);

        if(displayedValue < 200) {
            showCents = true;
        }

        data = info.formats[displayedCurrency];

        if(showCents && cents)
            if(whole)
                result = format(data.template, whole, cents);
            else
                result = format(data.template_cents, cents);
        else
            result = format(data.template_whole, whole);

        result = result.replace(/<unit>(.*?)<\/unit>/g, unitWrapper);

        // RASP-14643 по верcтке необходимо "от" включить в целую часть, но только если в переводе предлог стоит в начале
        if(params.from) {
            // определяем положение предлога в переводе
            var fromTranslate = BEM.I18N('b-currency', 'currency-from', { 'value': '$1' });
            if (fromTranslate.indexOf('$1') === 0 || result.indexOf('whole') === -1) {
                result = BEM.I18N('b-currency', 'currency-from', { 'value': result });
            } else {
                wholeWrapper = wholeWrapper.split('$1').join(fromTranslate);
            }
        }

        result = result.replace(/<whole>(.*?)<\/whole>/g, wholeWrapper);

        return result;

    },

    live: function() {

        BEM.blocks['b-page'].on('change-currency', function(e) {

            $.cookie('preferredcurrency', BEM.blocks['i-global'].param('currency').selected, { path: '/' });

            $.each(e.block.findBlocksInside('b-currency'), function() {
                this._onChangeCurrency();
            });

        });

    }

});

})();
