(function() {

BEM.DOM.decl({ name: 'b-map', modName: 'type', modVal: 'trains' }, {

    onSetMod: {
        'js': function() {
            // RASP-3245, растягиваем карту вниз
            if(!this.hasMod('size', 'big')) {
                var $map = $(this.domElem),
                    mapExtendedHeight = $(window).height() - $map.offset().top;
                if(mapExtendedHeight > $map.height()) {
                    $map.height(mapExtendedHeight);
                }
            }

            this.map = null;
            this.mediaUrl = BEM.blocks['i-global'].param('static-host');
            this.dataUrl = this.params['data-url'];
            this.boundsTimeout = null;
            this.trainsSpriteUrl = this.mediaUrl + 'i/maps/';
            this.activeTrain = null; // Выделенный маршрут
            this.fetchSafetyMargin = 60, // через сколько секунд до expire обновлять данные

            this.trains = {};
            this.dataTime; // Опорное время данных
            this.expires; // Время протухания данных
            this.calcTime; // Время для расчетов
            this.positionTimeout;
            this.filters = {};
            this.eventHandler = $('<div>voila</div>');

            this.iType = 0;
            this.iPath = 1;

            this.iTimestamp = 0;
            this.iLng = 1;
            this.iLat = 2;

        }
    },

    init: function(options, setHashMapParams) {
        var _this = this;
        this.overlays = [];

        ymaps.ready(function() {

            _this.map = new ymaps.Map("b-map", {
                center: options.center,
                zoom: options.zoom,
                behaviors: ["default", "scrollZoom"]
            });

            _this.map.controls
                .add("zoomControl")
                .add(new ymaps.control.TypeSelector())
                .add("mapTools")
                .add("scaleLine");
            _this.eventHandler.trigger('map-ready');

            _this.map.events.add('boundschange', function (event) {
                clearTimeout(_this.boundsTimeout);
                _this.boundsTimeout = setTimeout(function() {
                    _this.onBoundsChange();
                }, 1000);
            });

            _this.map.events.add('click', function (event) {
                _this.hideRouteInfo();
            });

            _this.createStyles();

            setHashMapParams(_this.map);
        });

    },

    onBoundsChange: function() {
        BEM.channel('b-map_type_trains').trigger('bounds-change', this.map);
        this.fetchTrains();
    },

    filter: function(newFilters, search, callback) {
        var _this = this;
        this.filters = newFilters;

        this.hideRouteInfo();

        $.getJSON(this.dataUrl + 'bounds?callback=?', this.filters, function (data) {
            var bounds = [[data.left, data.bottom], [data.right, data.top]];

            if(typeof callback == 'function') {
                callback(data.count);
            }

            if(data.count) {

                _this.callWhenMapReady(function() {
                    (function(__this) {
                        var map = __this.map,
                            mapBounds = map.getBounds();
                        if(search) {
                            // Если это был поиск, то центрируем карту по результатам
                            if(Math.min(Math.abs(bounds[0][0] - bounds[1][0]), Math.abs(bounds[0][1] - bounds[1][1])) < 4) {
                                bounds[0][0] -= 5;
                                bounds[0][1] -= 5;
                                bounds[1][0] += 5;
                                bounds[1][1] += 5;
                            }
                            map.setBounds(bounds, {precizeZoom: true, checkZoomRange: true});
                        } else {
                            // Иначе перемещаем только если результаты не попадают во вьюпорт
                            if((mapBounds[1][0] < bounds[0][0] || bounds[1][0] < mapBounds[0][0]) ||
                                (mapBounds[1][1] < bounds[0][1] || bounds[1][1] < mapBounds[0][1]))
                            {
                                bounds = [[Math.min(mapBounds[0][0], bounds[0][0]), Math.min(mapBounds[0][1], bounds[0][1])], [Math.max(mapBounds[1][0], bounds[1][0]), Math.max(mapBounds[1][1], bounds[1][1])]];
                                if(Math.min(Math.abs(bounds[0][0] - bounds[1][0]), Math.abs(bounds[0][1] - bounds[1][1])) < 4) {
                                    bounds[0][0] -= 5;
                                    bounds[0][1] -= 5;
                                    bounds[1][0] += 5;
                                    bounds[1][1] += 5;
                                }
                                map.setBounds(bounds, {precizeZoom: true, checkZoomRange: true});
                            }
                        }
                    })(_this);
                });

            }

            clearTimeout(this.boundsTimeout);

            _this.callWhenMapReady(function() {_this.fetchTrains();});
        });

    },

    callWhenMapReady: function(callback) {
        if(this.map) {
            callback();
        } else {
            this.eventHandler.on('map-ready', callback);
        }
    },

    viewportParams: function(filters) {
        if(this.map) {
            var bounds = this.map.getBounds(),
                center = [(bounds[1][0] + bounds[0][0]) / 2, (bounds[1][1] + bounds[0][1]) / 2];

            return $.extend({}, filters || {}, {
                center: '' + center[0] + ',' + center[1],
                span: '' + (bounds[1][0] - bounds[0][0]) + ',' + (bounds[1][1] - bounds[0][1]),
                zoom: Math.floor(this.map.getZoom())
            });
        } else {
            return filters;
        }
    },

    fetchTrains: function() {
        var _this = this,
            params = this.viewportParams(this.filters);

        if(this.activeTrain) {
            params['uid'] = this.activeTrain;
        }

        $.getJSON(this.dataUrl + 'objects?callback=?',
            params,
            function (data) {
                if(data == null) {
                    // Если пришли плохие данные, будем пытаться снова, но чуть позже
                    setTimeout(function() {_this.updateTrains(data.objects)}, 3000);
                    return;
                }

                _this.dataTime = data.timestamp;
                _this.expires = data.expires;

                // Если устарело ещё при загрузке, значит сломался серверный скрипт
                if(_this.expires - _this.fetchSafetyMargin < _this.getTime()) {
                    // чтобы не циклилось, но и не прерывало насовсем процесс
                    setTimeout(function() {_this.updateTrains(data.objects)}, 1000);
                } else {
                    _this.updateTrains(data.objects);
                }

                // Обновление информации, если она есть
                if(data.info && data.info.uid in _this.trains)
                    _this.showRouteInfo(data.info.uid, data.info);
                else
                    _this.hideRouteInfo();
            }
        );
    },

    /*
     * Время в секундах, с учетом поправок
     */
    getTime: function() {
        return new Date().getTime() / 1000 + timeCorrection;
    },

    /*
     * Обновление паровозиков из свежих данных
     */
    updateTrains: function(data) {
        var _this = this,
            current = this.getTime(),
            kmPerPx = 20000 / (256 * Math.pow(2, Math.floor(this.map.getZoom()))),
            interval = Math.max(kmPerPx / 200 * 3600, 1);

        this.calcTime = current - this.dataTime;

        if(current + this.fetchSafetyMargin > this.expires) {
            // Данные очень скоро протухнут, надо перезагрузить
            this.fetchTrains();
            return;
        }

        // Тупое обновление позиций
        if(typeof data != 'object') {
            $.each(this.trains, function (uid, train) {
                // Обновление положения
                if(!train.updatePosition()) {
                    // Поезд доехал до конца
                    _this.trains[uid].removePm();
                    delete _this.trains[uid];
                }
            });
        } else {
            // Обновление по свежим данным
            // Пробегаемся по имеющимся поездам
            $.each(this.trains, function(uid, train) {
                // Апдейтим или убираем
                if(uid in data) {
                    train.updateData(data[uid]);

                    // Удаляем из данных, чтобы потом добавить только новые
                    delete data[uid];
                } else {
                    _this.trains[uid].removePm();
                    delete _this.trains[uid];
                }

            });

            // Добавляем новые
            $.each(data, function(uid, data) {
                _this.addTrain(uid, data);
            });

        }

        if(_this.positionTimeout) {
            clearTimeout(_this.positionTimeout);
        }

        _this.positionTimeout = setTimeout(function(){_this.updateTrains()}, interval * 1000);

    },

    crc8tab: [
        0x00,0x1B,0x36,0x2D,0x6C,0x77,0x5A,0x41,0xD8,0xC3,0xEE,0xF5,0xB4,0xAF,0x82,0x99,0xD3,0xC8,0xE5,
        0xFE,0xBF,0xA4,0x89,0x92,0x0B,0x10,0x3D,0x26,0x67,0x7C,0x51,0x4A,0xC5,0xDE,0xF3,0xE8,0xA9,0xB2,
        0x9F,0x84,0x1D,0x06,0x2B,0x30,0x71,0x6A,0x47,0x5C,0x16,0x0D,0x20,0x3B,0x7A,0x61,0x4C,0x57,0xCE,
        0xD5,0xF8,0xE3,0xA2,0xB9,0x94,0x8F,0xE9,0xF2,0xDF,0xC4,0x85,0x9E,0xB3,0xA8,0x31,0x2A,0x07,0x1C,
        0x5D,0x46,0x6B,0x70,0x3A,0x21,0x0C,0x17,0x56,0x4D,0x60,0x7B,0xE2,0xF9,0xD4,0xCF,0x8E,0x95,0xB8,
        0xA3,0x2C,0x37,0x1A,0x01,0x40,0x5B,0x76,0x6D,0xF4,0xEF,0xC2,0xD9,0x98,0x83,0xAE,0xB5,0xFF,0xE4,
        0xC9,0xD2,0x93,0x88,0xA5,0xBE,0x27,0x3C,0x11,0x0A,0x4B,0x50,0x7D,0x66,0xB1,0xAA,0x87,0x9C,0xDD,
        0xC6,0xEB,0xF0,0x69,0x72,0x5F,0x44,0x05,0x1E,0x33,0x28,0x62,0x79,0x54,0x4F,0x0E,0x15,0x38,0x23,
        0xBA,0xA1,0x8C,0x97,0xD6,0xCD,0xE0,0xFB,0x74,0x6F,0x42,0x59,0x18,0x03,0x2E,0x35,0xAC,0xB7,0x9A,
        0x81,0xC0,0xDB,0xF6,0xED,0xA7,0xBC,0x91,0x8A,0xCB,0xD0,0xFD,0xE6,0x7F,0x64,0x49,0x52,0x13,0x08,
        0x25,0x3E,0x58,0x43,0x6E,0x75,0x34,0x2F,0x02,0x19,0x80,0x9B,0xB6,0xAD,0xEC,0xF7,0xDA,0xC1,0x8B,
        0x90,0xBD,0xA6,0xE7,0xFC,0xD1,0xCA,0x53,0x48,0x65,0x7E,0x3F,0x24,0x09,0x12,0x9D,0x86,0xAB,0xB0,
        0xF1,0xEA,0xC7,0xDC,0x45,0x5E,0x73,0x68,0x29,0x32,0x1F,0x04,0x4E,0x55,0x78,0x63,0x22,0x39,0x14,
        0x0F,0x96,0x8D,0xA0,0xBB,0xFA,0xE1,0xCC,0xD7
    ],

    crc8str: function(str) {
        var n,
            len = str.length,
            crc;

        for(n = 0; n < len; n++) {
            crc = this.crc8tab[(crc ^ str.charCodeAt(n)) & 0xff];
        }

        return crc;
    },

    fetchRouteInfo: function(uid) {
        var _this = this,
            params = {
                uid: uid
            };

        $.extend(params, this.viewportParams());

        // Делаем серыми другие поезда
        $.each(this.trains, function(u, train) {
            if(u != uid) {
                train.gray();
            }
        });

        this.trains[uid].colorize();

        // Показывем спиннер вместо контента
        this.showSpinner(uid);

        this.activeTrain = uid;

        $.getJSON(this.dataUrl + 'info?callback=?', params, function (data) {
            _this.showRouteInfo(uid, data);
        });
    },

    addTrain: function(uid, data) {
        var _this = this,
            train;

        function Train(uid, data) {
            var type = data[_this.iType],
                color = _this.crc8str(uid) % 4,
                position,
                properties = {
//                    hintContent: 'hintContent',
//                    balloonContent: 'balloon html'
                },
                options = {
                    draggable: false,
                    preset: _this.trainPresetName(0, 0)
                },
                train = this;
            train.pm = null;

            this.createPm = function() {
                if(!train.pm) {;

                    train.pm = new ymaps.Placemark(
                        position,
                        properties,
                        options
                    );
                    _this.map.geoObjects.add(train.pm);

                    train.pm.events.add('click', function(e) {
                        _this.fetchRouteInfo(uid);
                    });
                }
            };

            this.removePm = function() {
                if(train.pm) {
                    _this.map.geoObjects.remove(train.pm);
                }
            };

            this.updatePosition = function() {
                position = _this.computePosition(data[_this.iPath]);

                if(position === null)
                    return false;

                // Если ещё не отправился, ничего не делаем
                if(position === 'wait')
                    return true;

                // Показываем, если не был до этого
                this.createPm();

                if(train.pm) {
                    train.pm.geometry.setCoordinates(position)
                }

                return true;
            };

            this.updateData = function(d) {
                data = d;
                this.updatePosition();
            };

            this.setIcon = function(c, t) {
                var map;
                options['preset'] = _this.trainPresetName(c, t);
                if(train.pm) {
                    map = train.pm.getMap();
                    map.geoObjects.remove(train.pm);
                    train.pm.options.set('preset', options['preset']);
                    map.geoObjects.add(train.pm);
                }
            };

            this.gray = function() {
                this.setIcon(0, type);
            };

            this.colorize = function() {
                this.setIcon(color + 1, type);
            };

            this.openBalloon = function(content) {
                this.createPm();
                this.setBalloonContent(content);
                train.pm.balloon.open();
            };

            this.closeBalloon = function(content) {
                if(train.pm) {
                    train.pm.balloon.close();
                }
            };

            this.setBalloonContent = function(content) {
                properties['balloonContent'] = content;
                if(train.pm) {
                    train.pm.properties.set('balloonContent', properties['balloonContent']);
                }
            };

            this.drawRoute = function(info) {
                _this.drawStationInfo(_this.map, info && info.routeMap, _this.routePresetName(color, type));
            };

            // Новые тоже нужно рисовать серыми, если какой-то выделен
            if(!_this.activeTrain)
                this.colorize();
            else
                this.gray();

        };

        train = new Train(uid, data);

        if(!train.updatePosition()) {
            // Какая-то ошибка, и поезд не нужно показывать
            return;
        }

        this.trains[uid] = train;

    },

    createStyles: function() {
        var _this = this,
            lineColors = [
                [
                    '74b5ec',
                    '2763ff',
                    '9b5bfd',
                    '65389c'
                ], [
                    '81b344',
                    '2ab329',
                    '588940',
                    '298126'
                ], [
                    'dd0000',
                    'dd0000',
                    'dd0000',
                    'dd0000'
                ]
            ],
            preset;

        for(var t = 0; t < 3; t++) {
            for(var c = 0; c < 4; c++) {

                preset = {
                    iconImageHref: _this.trainsSpriteUrl + 'stops_' + c + '_' + t + '.png',
                    iconImageSize: [9, 9],
                    iconImageOffset: [-4, -4],
                    strokeColor: '#' + lineColors[t][c],
                    strokeWidth: 3
                };

                ymaps.option.presetStorage.add(_this.routePresetName(c, t), preset);
            }

            for(var c = 0; c < 5; c++) {
                preset = {
                    iconImageHref: _this.trainsSpriteUrl + 'trains_' + c + '_' + t + '.png',
                    iconImageSize: [28, 26],
                    iconImageOffset: [-9, -23]
                };

                ymaps.option.presetStorage.add(_this.trainPresetName(c, t), preset);
            }
        }

    },

    routePresetName: function(c, t) {
        return "trains#route-" + t + '-' + c;
    },

    trainPresetName: function(c, t) {
        return "trains#train-" + t + '-' + c;
    },

    /*
     * Рассчет текущего положения
     */
    computePosition: function(path) {
        // Удаляем пройденные участки пути
        while(path.length > 1 && path[1][this.iTimestamp] < this.calcTime) {
            path.shift();
        }

        if(path.length < 2) {
            // Поезд исчез
            return null;
        }

        var p0 = path[0],
            p1 = path[1],
            lng = p0[this.iLng],
            lat = p0[this.iLat],
            dLng = p1[this.iLng] - lng,
            dLat = p1[this.iLat] - lat;

        if(p0[this.iTimestamp] > this.calcTime) {
            // Поезд ещё не отправился
            return 'wait';
        }

        if(dLng != 0 && dLat != 0) {
            var dT = p1[this.iTimestamp] - p0[this.iTimestamp],
                t = this.calcTime - p0[this.iTimestamp],
                k = t / dT;

            lng += dLng * k,
                lat += dLat * k;
        }

        return [lng, lat];
    },

    showSpinner: function(uid) {
        var data = {handled: false, info: 'spinner'};

        BEM.channel('b-map_type_trains').trigger('info', data);

        if(!data.handled) {
            var train = this.trains[uid];
            train.openBalloon('<img src="http://lego.static.yandex.net/2.1/common/block/b-spin/_size/b-spin_16.gif" />');
        }
    },

    showRouteInfo: function(uid, info) {
        if(!info) {
            return;
        }
        var train = this.trains[uid],
            data = {info: info, handled: false};

        BEM.channel('b-map_type_trains').trigger('info', data);

        train.drawRoute(info);

        if(!data.handled) {
            train.openBalloon(
                '<div>' +
                '<strong>' + info.title.replace(' - ', '&nbsp;&mdash; ') + '</strong><br />' +
                '<a href="' + info.url + '">' + BEM.I18N('b-maps-search', 'train', { 'train-number': info.number }) + '</a><br />' +
                (info.left > 0 ? BEM.I18N('b-maps-search', 'arrival-in-train', { 'time-left': BEM.blocks['i-time'].humanDuration(info.left) }): BEM.I18N('b-maps-search', 'arrived')) +
                '</div>'
            );
        }
    },

    hideRouteInfo: function() {

        if(!this.activeTrain) {
            return;
        }

        var data = {info: '', handled: false};

        BEM.channel('b-map_type_trains').trigger('info', data);

        this.clearStationInfo();

        if(!data.handled) {
            var train = this.trains[this.activeTrain];

            if(train) {
                this.map.balloon.close();
            }
        }

//        this.map.geoObjects.remove(this.trainsCollection);
        $.each(this.trains, function(u, train) {
            train.colorize();
        });
//        this.map.geoObjects.add(this.trainsCollection);

        this.activeTrain = undefined;
    },

    clearStationInfo: function() {
        $.each(this.overlays, function(k, obj) {
            obj.getMap().geoObjects.remove(obj);
        });

        this.overlays = [];
    },

    drawStationInfo: function(map, data, preset) {
        var _this = this;
        _this.clearStationInfo();

        if(!data) {
            return;
        }

        $.each(data.segments, function(i, segment) {
            if(segment === null) {
                // Пропускаем пустые сегменты
                return;
            }

            var polyline = new ymaps.Polyline(segment[0], {}, {preset: preset});

            map.geoObjects.add(polyline);

            _this.overlays.push(polyline);
        });

        $.each(data.stations, function(i, station) {
            if(station[0] === null) {
                // если не указаны координаты, то пропускаем
                return;
            }

            var placemark,
                name = station[1],
                arrival = station[2],
                departure = station[3],
                id = station[4],
                times = '',
                link = '',
                properties = {};


            if(arrival) {
                times = BEM.I18N('b-map', 'arrival', { time: arrival });
            }

            if(departure) {
                var str = BEM.I18N('b-map', 'departure', { time: departure });

                if(arrival) {
                    times += ', ' + str;
                } else {
                    times = str;
                }
            }

            if(id) {
                link = '<a href="/station/' + id + '/">' + BEM.I18N('b-map', 'station-panel') + '</a><br />';
            }

            properties['balloonContent'] = '<div>'
                + '<strong>' + name + '</strong>' + ((times || link) && '<br/>')
                + times + (times && link && '<br />') + link
            + '</div>';

            placemark = new ymaps.Placemark([station[0][0], station[0][1]],
                properties,
                {preset: preset});

            map.geoObjects.add(placemark);

            _this.overlays.push(placemark);
        });
    }

});

})();
