BEM.DOM.decl({block: 'b-page-calendar', modName: 'timezone', modValue: 'change'}, {

    onSetMod: {

        'js': function() {
            this.__base.apply(this, arguments);

            this.params['timezone'] = 'local';

            BEM.blocks['b-page'].on('change-tz', this._onTimeZoneChange, this);
        }
    },

    _onTimeZoneChange: function(e, tz) {
        var tzId = (tz || 'local').toString(),
            current = this.getCurrent(),
            monthName = current.attr('data-month-name');

        this.params['timezone'] = tzId;

        var elem = this.findElem('calendar', 'timezone', tzId.toString()).
                        filter(function() {
                            return $(this).attr('data-month-name') == monthName;
                        });

        this.setMod(current, 'state', 'hidden');
        this.setMod(elem, 'state', 'current');

    },

    getSelector: function() {
        return this.buildSelector('calendar', 'timezone', this.params['timezone']);
    }
});