BEM.DOM.decl('b-page-calendar', {
    onSetMod: {
        'js': {
            'inited': function() {
                this.bindTo(this.elem('arrow', 'type', 'prev'), 'click', this.onPrevMonth);
                this.bindTo(this.elem('arrow', 'type', 'next'), 'click', this.onNextMonth);
            }
        }
    },
    getSelector: function() {
        return this.buildSelector('calendar');
    },
    getCurrent: function() {
        return this.elem('calendar', 'state', 'current');
    },
    onNextMonth: function(e) {
        e.preventDefault();

        var current = this.getCurrent(),
            next = current.next(this.getSelector()),
            nextNext = next.next(this.getSelector()).length;

        this.setMod(current, 'state', 'hidden');
        this.setMod(next, 'state', 'current');

        this.delMod(this.elem('arrow', 'type', 'prev'), 'state', 'hidden');
        if(!nextNext)
            this.setMod(this.elem('arrow', 'type', 'next'), 'state', 'hidden');
        this.elem('month-name').html(next.attr('data-month-name'));
    },
    onPrevMonth: function(e) {
        e.preventDefault();

        var current = this.getCurrent(),
            prev = current.prev(this.getSelector()),
            prevPrev = prev.prev(this.getSelector()).length;

        this.setMod(current, 'state', 'hidden');
        this.setMod(prev, 'state', 'current');

        this.delMod(this.elem('arrow', 'type', 'next'), 'state', 'hidden');
        if(!prevPrev)
            this.setMod(this.elem('arrow', 'type', 'prev'), 'state', 'hidden');
        this.elem('month-name').html(prev.attr('data-month-name'));
    },
    redraw: function(current, active) {
    // TODO
    }
});
