(function() {

var URL = BEM.blocks['i-url'];

BEM.DOM.decl('b-page', {

    onSetMod: {

        'js': function() {

            var self = this.__self,
                _this = this,
                $html = $(document.documentElement);

            $html.attr('prefix', 'og: http://ogp.me/ns#');

            self.timeZone = this.params['time-zone-id'];
            self.now = new Date(this.params['now']);
            self.params = this.params;

            self.pageParams = URL.parseQuery(document.location.search, true);

            this.on('change-params', function(e, params) {

                URL.updateParams(self.pageParams, params);

                if('currency' in params) {

                    var currency = params.currency;

                    BEM.blocks['i-global'].param('currency').selected = currency;

                    this.trigger('change-currency', currency);

                }

                if('time_zone' in params) {

                    self.timeZone = params.time_zone;

                    this.trigger('change-tz', params.time_zone);

                }

                if('city' in params) {
                    this.trigger('change-city', params.city);
                }

                $.each(params, function(name, value) {

                    var indicators = _this.findBlocksInside({ block: 'i-params-indicator', modName: 'param', modVal: name });

                    $.each(indicators, function() {

                        var displayValue = this.params[value];

                        this.domElem.find(':only-child:last').html(displayValue);

                    });

                });

                $.each(this.findBlocksInside({ block: 'b-link', modName: 'pass-params', modVal: 'yes' }), function() {

                    var url = this.domElem.attr('href'),
                        newUrl = URL.changeParams(url, params, [ 'details' ]);

                    this.domElem.attr('href', newUrl);

                });

            });

            // Для инициализации блоков сразу при загрузке страницы даже при наличии секции live
            this.findBlocksInside('b-short-search');

            // Хак для передачи языка в сабмиты форм
            var lang = self.pageParams.lang;
            if (lang) {
                var $forms = this.domElem.find('form')
                    .filter(function() {
                        var action = this.getAttribute('action');
                        return action && action.indexOf('//') < 0;
                    })
                    .not(':has(input[name=lang])');

                $forms.append($('<input name="lang" type="hidden"/>').attr('value', lang));
            }

        }

    }

});

})();
