BEM.DOM.decl('b-timetable-slider', {

    onSetMod : {

        'js' : function() {
            var _this = this;
            this.timetable = this.findBlockOutside('b-page').findBlockInside('b-timetable');
            this.links = this.findBlockOutside('b-page').findBlocksInside('b-slider-link');

            this.now = this.params['now'],
            this.limits = this.params['limits'], // Ограничения слайдера по времени

            this.spinner = {
                start : function() {
                    _this.setMod(_this.elem('slider'), 'state', 'busy');
                },
                stop : function() {
                    _this.delMod(_this.elem('slider'), 'state', 'busy');
                }
            };

            BEM.channel('search-route').on('search', function(e, query) { _this._search(query) });

            this.HOUR_WIDTH = 8.0 / 4; // Длина часа на шкале в процентах
            this.MIN_WIDTH = this.HOUR_WIDTH;
            this.MAX_WIDTH = this.HOUR_WIDTH * 24;

            this.currentQuery = '';

            this.initScale(this.params['scale']);
            this.adjustLimits();
            this.bindings();

            this._initButtons();
        }

    },

    initScale : function(data) {
        // Положение слайдера во времени, соответствующее отображаемым рейсам
        this.current = data.current;
        // Отображаемый размер слайдера
        this.currentSpan = data.span;
        this.scaleStart = new Date(data.start);
    },

    // Лимиты нужно менять при переключении временной зоны
    adjustLimits : function() {
        var _this = this;
        // Ограничения движения слайдера по шкале, в процентах
        this.scaleLimits = $.map(this.limits, function(limit) {
            return _this.dateToPosition(_this.dateAdjusted(limit));
        });
    },

    dateToPosition : function(date) {
        return (date.getTime() - this.scaleStart.getTime()) / 3600000 * this.HOUR_WIDTH;
    },

    query_params : function(start, span) {
        var params = window.location.search ? BEM.blocks['i-url'].parseQuery(window.location.search) : {},
            requestedTZ = BEM.blocks['b-page'].timeZone,
            shift = requestedTZ ? this.current.shifts[requestedTZ] : 0;

        params.start = this.toISOString(new Date(start.getTime() - shift * 60000));
        params.span = Math.round(span);
        params.scaleLeft = this.toISOString(new Date(this.scaleStart.getTime() - shift * 60000));
        params.query = this.currentQuery;

        // Если временную зону не меняли, то она уже указана в URL
        if(requestedTZ) {
            params.time_zone = requestedTZ;
        }

        return params;
    },

    _search : function(query) {
        var _this = this,
            pos = this.slider('left'),
            width = this.slider('width'),
            start = new Date(this.scaleStart.getTime() + Math.round(pos / this.HOUR_WIDTH) * 3600 * 1000),
            span = width / this.HOUR_WIDTH;

        this.currentQuery = query;
        var p = this.query_params(start, span);
        p['query'] = query;
        this.spinner.start();

        $.ajax({
            url: '?' + $.param(p, true),
            dataType: 'json',
            success: function(data){_this._onLoad(data);}
        });
    },

    _default_search : function() {
        var _this = this;

        this.currentQuery = '';

        $.ajax({
            dataType: 'json',
            success: function(data){_this._onLoad(data);}
        });
    },

    _onLoad : function(data) {

        var bemjson = [{ block: 'i-global', params: BEM.blocks['i-global']._params }, data.scale_bemjson],
            html = BEMHTML.apply(bemjson);

        this.findElem('scale').replaceWith(html);
        this.now = data.slider.now;
        this.limits = data.slider.limits;

        this.initScale(data.slider.scale);
        this.resetSlider();
        this.adjustLimits();

        // timetable rows
        html = data.timetable_rows;

        this.timetable.findElem('row').remove();
        this.timetable.domElem.append(html);

        this._initButtons();
        this.spinner.stop();
    },

    _initButtons : function() {
        var _this = this;
        this.timetable.findBlocksInside('b-form-button').map(function(b) {
            b.on('click', function() {
                BEM.channel('search-route').trigger('clear');
                _this._default_search();
            });
        });
    },

    slider : function(property) {
        var value = this.elem('slider').css(property);

        if(value.substr(value.length - 2) == 'px')
            return parseFloat(value) * 100 / this.findElem('scale').width();
        else
            return parseFloat(value);
    },

    drop : function() {
        var pos = this.slider('left'),
            width = this.slider('width'),
            start = new Date(this.scaleStart.getTime() + Math.round(pos / this.HOUR_WIDTH) * 3600 * 1000),
            span = width / this.HOUR_WIDTH;

        this.reload(start, span);
    },

    reload : function(start, span) {
        var _this = this;
        // Не грузим, если слайдер остался на старом месте
        if(Math.floor(start.getTime() / 3600000) == Math.floor(this.dateAdjusted(_this.current).getTime() / 3600000) && span == _this.currentSpan)
            return;

        var p = this.query_params(start, span);
        this.spinner.start();

        $.ajax({
            url: '?' + $.param(p, true),
            dataType: 'json',
            success: function(data){_this._onLoad(data);}
        });
    },

    drag : function(e, cb) {
        var _this = this;

        e.preventDefault();
        e.stopPropagation();

        this.elem('slider').css('cursor', 'move');
        $(document.body).css('cursor', 'move');

        var startX = e.pageX,
            scaleWidth = this.findElem('scale').width();

        $(document).bind('mousemove.drag', function(e) {
            cb((e.pageX - startX) / scaleWidth * 100);
        });

        $(document).bind('mouseup.drag', function(e) {
            $(document).unbind('.drag');
            $(document.body).css('cursor', 'auto');
            _this.elem('slider').css('cursor', 'pointer');

            _this.drop();
        });
    },

    clamp : function(value, min, max) {
        var clamped = Math.max(Math.min(value, max), min);
        return Math.round(clamped / this.HOUR_WIDTH) * this.HOUR_WIDTH;
    },

    // Установка слайдера по местному времени, нужна при подгрузке шкалы
    // (она может сместиться) и при переключении временной зоны
    resetSlider : function() {
        var _this = this,
            position = (this.dateAdjusted(this.current).getTime() - this.scaleStart.getTime()) / 3600000 * this.HOUR_WIDTH;

        this.elem('slider').css('left', position + '%');
        this.elem('slider').css('width', (this.currentSpan * this.HOUR_WIDTH) + '%');

        $.each(this.links, function(j, b_link) {
            var day = parseInt(b_link.params['day']),
                d = BEM.blocks['i-time'].addDays(_this.dateAdjusted(_this.now), day);

            if(BEM.blocks['i-time'].dateEqual(d, _this.dateAdjusted(_this.current))) {
                b_link.setMod('state', 'current');
                b_link.elem('link').addClass('i-hidden');
                b_link.elem('text').removeClass('i-hidden');
            } else {
                b_link.delMod('state');
                b_link.elem('link').removeClass('i-hidden');
                b_link.elem('text').addClass('i-hidden');
            }
        });
    },

    _onTimeZoneChange: function(e, tz) {

        this.adjustLimits();

        this.resetSlider();

    },

    bindings : function() {
        var _this = this;

        BEM.blocks['b-page'].on('change-tz', this._onTimeZoneChange, this);

        this.elem('slider').on('mousedown', function(e) {
            var currentPos = _this.slider('left'),
                width = _this.slider('width');

            _this.drag(e, function(offset) {
                var left = _this.clamp(currentPos + offset, _this.scaleLimits[0], _this.scaleLimits[1] - width);
                _this.elem('slider').css('left', left + '%');
            });
        });

        this.elem('tack', 'type', 'left').on('mousedown', function(e) {
            var currentPos = _this.slider('left'),
                right = currentPos + _this.slider('width');

            _this.drag(e, function(offset) {
                var left = _this.clamp(currentPos + offset, Math.max(_this.scaleLimits[0], right - _this.MAX_WIDTH), right - _this.MIN_WIDTH),
                    width = right - left;

                _this.elem('slider').css('left', left + '%');
                _this.elem('slider').css('width', width + '%');
            });
        });

        this.elem('tack', 'type', 'right').on('mousedown', function(e) {
            var left = _this.slider('left'),
                currentWidth = _this.slider('width');

            _this.drag(e, function(offset) {
                var width = _this.clamp(currentWidth + offset, _this.MIN_WIDTH, Math.min(_this.MAX_WIDTH, _this.scaleLimits[1] - left));

                _this.elem('slider').css('width', width + '%');
            });
        });

    },

    // Из объекта получает и применяет сдвиг
    dateAdjusted : function(dt_obj, msk) {
        var local = new Date(dt_obj.local),
            rv,
            requestedTZ = BEM.blocks['b-page'].timeZone;

        if(isNaN(local.getTime()))
            throw "Invalid date value " + dt_obj.local;

        // если запросили по москве
        if(msk && dt_obj.shifts[213]) {
            rv = new Date(local.getTime() + dt_obj.shifts[213] * 60000);
        } else {
            if(!requestedTZ) {
                // местное время
                rv = local;
            } else {
                var shift = dt_obj.shifts[requestedTZ] || 0;
                // возвращаем в запрошенной временной зоне
                rv = new Date(local.getTime() + shift * 60000);
            }
        }

        return rv;
    },

    toISOString : function(d) {
        return d.getFullYear() + '-' + BEM.blocks['i-time'].padTwo(d.getMonth() + 1) + '-' + BEM.blocks['i-time'].padTwo(d.getDate()) + 'T' + BEM.blocks['i-time'].padTwo(d.getHours()) + ':' + BEM.blocks['i-time'].padTwo(d.getMinutes()) + ':00';
    }

});


