(function() {

function cmpFactory(direction) {

    return function cmp(a, b) {

        // Сравнение массивов
        if(a instanceof Array && b instanceof Array) {

            for(var i = 0; i < a.length; i++) {

                var diff = cmp(a[i], b[i]);

                if(diff)
                    return diff;

            }

            return 0;

        }

        if(a === b) return 0;

        // Перемещаем null в конец списка (RASP-1984)
        if(a == null) return 1;
        if(b == null) return -1;

        if(a instanceof Array)
            return direction;

        else if(b instanceof Array)
            return -direction;

        return (a > b ? 1 : -1) * direction;

    };

};

function stabilizedCmpFactory(direction) {

    var stabilize = cmpFactory(1),
        cmp = cmpFactory(direction);

    function stabilizedCmp(a, b) {

        var diff = cmp(a.value, b.value);

        if(diff)
            return diff;

        return stabilize(a.stabilizers, b.stabilizers);

    }

    return stabilizedCmp;

}

BEM.DOM.decl({ block: 'b-timetable', modName: 'sort', modVal: 'yes' }, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            var _this = this,
                sortCells = this.elem('cell', 'sort-header', 'yes');

            this._sortValueCache = {};

            sortCells.each(function() {

                var cell = $(this);

                if(_this.hasMod(cell, 'sort')) {

                    _this.sortColumn = _this.getMod(cell, 'type');
                    _this.sortDirection = _this.getMod(cell, 'sort');

                }

                BEM.blocks['b-link'].on(cell, 'click', function() {

                    this.sortDirection = _this.getMod(cell, 'sort') == 'asc' ? 'desc': 'asc';
                    this.sortColumn = _this.getMod(cell, 'type');

                    this.delMod(sortCells,  'sort');
                    this.setMod(cell, 'sort', _this.sortDirection);

                    this.sort();

                    this.redrawDates();

                    if(this.description) {

                        var showMidnightUp = this.sortColumn == 'departure' && this.sortDirection == 'asc';

                        this.description.elem('midnight-up')[showMidnightUp ? 'removeClass' : 'addClass']('i-hidden');

                    }

                    var params = { sortBy: this.sortDirection == 'asc' ? this.sortColumn : '-' + this.sortColumn };

                    this.findBlockOutside('b-page').trigger('change-params', params);

                }, _this);

            });

        }

    },

    initSort: function() {

        if(this.sortInited)
            return;

        var _this = this,
            domRows,
            topRow,
            prevRow,
            topRowParent;

        domRows = this.elem('row', 'sortable', 'yes');

        this.rows = this.splitRows(domRows);

        topRow = domRows.eq(0);

        prevRow = topRow.prev();

        if(prevRow.length)
            this.prevRow = prevRow;
        else
            this.topRowParent = topRow.parent;

        this.sortInited = true;

    },

    updateRows: function(rows) {

        if(rows.length) {

            if(this.prevRow) {
                this.prevRow.after(rows);
            } else {
                this.topRowParent.prepend(rows);
            }

            BEM.DOM.init(rows);

        }

    },

    extractors: {

        'date-time': {

            sortValue: function(cell) {

                var time = this.findBlockInside(cell, 'i-time');

                return time.local.getTime();

            }

        },

        time: {

            sortValue: function(cell) {

                var time = this.findBlockInside(cell, 'i-time'),
                    display = time.displayTime();

                return [ display.getUTCHours(), display.getUTCMinutes() ];

            },

            tzDependent: true

        },

        raw:  {

            sortValue: function(cell) {

                return this.elemParams(cell)['sort-value'];

            }

        },

        price: {

            subSortValue: function(place) {

                var tariff = this.findBlockInside(place, 'b-currency');

                return tariff && tariff.params['sort-value'];

            },

            sortValue: function(cell) {

                var tariff = this.findBlockInside(cell, 'b-currency');

                return tariff && tariff.params['sort-value'];

            }

        }

    },

    splitRows: function(rows) {

        var _this = this,
            splitRows,
            data = {};

        splitRows = rows.map(function(i, row) {

            var $row= $(row),
                params = _this.elemParams($row),
                key = params.key,
                keyData = data[key] || (data[key] = {
                    domRows: []
                }),
                subPlaces = _this.findElem($row, 'sub-place'),
                details = $row.next(_this.detailsSelector),
                values;

            keyData.stabilizers = params.stabilizers || [];

            if(details.length) {
                keyData.details = details[0];
            }

            if(!keyData.baseUrl) {

                var container = _this.findElem($(row), 'sub-places');

                if(container.length)
                    keyData.baseUrl = _this.elemParams(container);

            }

            keyData.domRows.push(row);

            if(subPlaces.length) {

                return $.map(subPlaces, function(place) {

                    return {
                        key: key,
                        subPlace: $(place),
                        subPlaceIndex: _this.elemParams($(place)).index
                    };

                });

            }

            return {
                key: key
            };

        });

        return {
            split: splitRows,
            data: data
        };

    },

    sortValue: function(column, key, extractor) {

        var cache = this._sortValueCache[column] || (this._sortValueCache[column] = {}),
            row,
            cell;

        if(cache.hasOwnProperty(key))
            return cache[key];

        row = this.rows.data[key].domRows[0];

        cell = this.findElem($(row), 'cell', 'type', column);

        return (cache[key] = cell.length ? extractor.sortValue.call(this, cell) : null);

    },

    sortRows: function(column, extractor, direction) {

        var _this = this,
            cmp = stabilizedCmpFactory(direction);

        if(extractor.tzDependent) {

            var tz = BEM.blocks['b-page'].timeZone,
                cache = this._sortValueCache[column];

            if(cache === undefined || cache._tz != tz) {
                this._sortValueCache[column] = { _tz: tz };
            }

        }

        var blablacarRow;
        var oldBlablacarIndex;


        this.rows.split.each(function(index) {

            if (typeof(this.key) === 'string' && this.key.indexOf('bla-bla-car') == 0) {
                blablacarRow = this;
                oldBlablacarIndex = index;
            } else {
                var sortValue;

                if (extractor.subSortValue && this.subPlace)
                    sortValue = extractor.subSortValue.call(_this, this.subPlace);

                if (sortValue === undefined)
                    sortValue = _this.sortValue(column, this.key, extractor);

                this.sortValue = {
                    value: sortValue,
                    stabilizers: _this.rows.data[this.key].stabilizers.concat([this.key, this.subPlaceIndex])
                };
            }

        });

        if (oldBlablacarIndex !== undefined) {
            this.rows.split.splice(oldBlablacarIndex, 1);
        }

        this.rows.split.sort(function(rowA, rowB) {

            return cmp(rowA.sortValue, rowB.sortValue);

        });

        if (blablacarRow) {
            var prevKey;
            var keyCount = 0;
            var newBlablacarIndex = 0;

            this.rows.split.each(function() {
                newBlablacarIndex++;

                if ($(_this.rows.data[this.key].domRows).filter('.i-hidden').length === 0 && this.key != prevKey) {
                    prevKey = this.key;
                    keyCount++;

                    if (keyCount == _this.params.blablacarPosition + 1) {
                        newBlablacarIndex--;
                        return false;
                    }
                }
            });

            this.rows.split.splice(newBlablacarIndex, 0, blablacarRow);
        }
    },

    mergeRows: function() {

        var _this = this,
            prevKey,
            domRowIndexes = {},
            displayRow,
            displayRows;

        displayRows = this.rows.split.map(function(i, value) {

            var key = value.key,
                domRow,
                rv;

            if(key != prevKey) {

                var domRowIndex = domRowIndexes[key] || 0,
                    data = _this.rows.data[key],
                    domRows = data.domRows;

                prevKey = key;

                if(domRowIndex >= domRows.length) {

                    domRow = $(domRows[0]);

                    // Убираем sub-place, чтобы они не наплодились при клонировании domRow
                    _this.findElem(domRow, 'sub-place').detach();

                    var clone = domRow.clone();

                    clone.find('.i-bem').each(function(i, domNode) {
                        domNode.className = domNode.className.replace(/(^| )[a-z0-9-_]+_js_inited( |$)/ig, ' ');
                    });

                    domRows.push(clone[0]);

                }

                domRow = domRows[domRowIndex];

                domRowIndexes[key] = domRowIndex + 1;

                displayRow = {
                    key: key,
                    places: $(),
                    domRow: domRow,
                    details: data.details
                };

                rv = displayRow;

            }

            if(value.subPlace !== undefined)
                displayRow.places.push(value.subPlace[0]);

            return rv;

        }).map(function() {

            if(this.places.length) {

                _this.findElem($(this.domRow), 'sub-places').append(this.places);

            }

            if(this.details)
                return [this.domRow, this.details];

            return this.domRow;

        });

        // Убираем неотображаемые строки из DOM
        $.each(this.rows.data, function(key, data) {

            var domRowIndex = (domRowIndexes[key] || 0);

            $(data.domRows.slice(domRowIndex)).detach();

        });

        return displayRows;

    },

    extractor: function() {

        var column = this.sortColumn;

        return this.extractors[this.params.columns[column]];

    },

    sort: function() {

        var column = this.sortColumn,
            direction = this.sortDirection,
            extractor = this.extractor();

        this.initSort();

        direction = direction == 'asc' ? 1 : -1;

        this.sortRows(column, extractor, direction);

        this.updateRows(this.mergeRows());

        this.dropElemCache();

        this.delMod(this.elem('cell', 'state', 'current'), 'state');

        this.setMod(this.elem('cell', 'type', column), 'state', 'current');

    },

    _onTimeZoneChange: function(e, tz) {

        if(this.extractor().tzDependent)
            this.sort();

        this.__base.apply(this, arguments);

    }

});

})();
