(function() {

var HTML = BEM.HTML,
    DOM = BEM.DOM,
    DAYNAMES = ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'вс'],
    MONTHNAMES = ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'],
    MONTHNAMESINFLECTED = ['января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'],
    TURKISH_MONTHMANES = ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'],
    TURKISH_DAYNAMES = ['pt', 'sa', 'ça', 'pe', 'cu', 'ct', 'pa'],

    MONTH_RE = [
        ['янв', 'фев', 'мар', 'апр', 'ма[йя]', 'июн', 'июл', 'авг', 'сен', 'окт', 'ноя', 'дек'],
        ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'],
        ['січня', 'лютого', 'березня', 'квітня', 'травня', 'червня', 'липня', 'серпня', 'вересня', 'жовтня', 'листопада', 'грудня']
    ],
    
    yearRegexps = $.map(MONTH_RE, function(res) {
        return [$.map(res, function(re) {
            return new RegExp('^\\s*(\\d{1,2})\\s+(' + re + ').*\\s+(\\d{4})', 'i')
        })];
    }),

    regexps = $.map(MONTH_RE, function(res) {
        return [$.map(res, function(re) {
            return new RegExp('^\\s*(\\d{1,2})\\s+(' + re + ')', 'i')
        })];
    });

function parseDateParts(str) {
    var match, month, i;

    match = /^\s*(\d{1,2})[./-](\d{1,2})(?:[./-](\d{4}|\d\d))?\s*$/.exec(str);

    if(match) {
        return [match[1], match[2] - 1, match[3]];
    }

    match = /^\s*(\d{4})[./-](\d\d)(?:[./-](\d\d))?\s*$/.exec(str);

    if(match) {
        return [match[3], match[2] - 1, match[1]];
    }

    for(month = 0; month < 12; month++) {
        for(i = 0; i < yearRegexps.length; i++) {
            match = yearRegexps[i][month].exec(str);

            if(match)
                return [match[1], month, match[3]];
        }
    }

    for(month = 0; month < 12; month++) {
        for(i = 0; i < regexps.length; i++) {
            match = regexps[i][month].exec(str);

            if(match)
                return [match[1], month];
        }
    }

    return null;

}

function monthDiff(a, b) {
    return (a.getUTCFullYear() - b.getUTCFullYear()) * 12 + (a.getUTCMonth() - b.getUTCMonth());
}

function monthAdd(month, delta) {
    var copy = new Date(month.getTime());

    copy.setUTCDate(1);
    copy.setUTCMonth(copy.getUTCMonth() + delta);

    return copy;
}

function dayAdd(date, delta) {
    var copy = new Date(date.getTime());

    copy.setUTCDate(copy.getUTCDate() + delta);

    return copy;
}

BEM.decl('i-calendar', {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);

            var now = BEM.blocks['b-page'].now;

            this.lang = BEM.blocks['i-global'].param('lang');

            this.today = new Date(now.getTime());

            this.today.setUTCHours(0);
            this.today.setUTCMinutes(0);
            this.today.setUTCSeconds(0);
            this.today.setUTCMilliseconds(0);

            this.earlyLimit = this.params['early-limit'] || new Date(BEM.blocks['b-page'].params['early-limit']);
            this.lateLimit = this.params['future-limit'] || new Date(BEM.blocks['b-page'].params['late-limit']);

            // перезатираем список месяцев и дней недели локализованными
            if (this.lang === 'tr') {
                MONTHNAMES = TURKISH_MONTHMANES;
                DAYNAMES = TURKISH_DAYNAMES;
            }

            if (this.lang === 'uk') {
                MONTHNAMES = BEM.blocks['i-time-translations'].monthsTranslations.getList('uk', 'n');
                DAYNAMES = BEM.blocks['i-time-translations'].daysTranslations.getList('uk', 'short');
            }

        }

    },

    show: function(elem, date) {

        var popup = this._getPopup();

        this._month = new Date(this.today.getTime());
        this._month.setUTCDate(1);

        this._selected = date;

        if(this._selected && !this._isValidDate(this._selected))
            this._selected = null;

        if(!this._selected)
            this._selected = this.today;

        if(this._selected) {
            this._month = new Date(this._selected.getTime());
            this._month.setUTCDate(1);
        }

        this._buildCalendar();

        popup.show(elem);

    },

    hide: function() {

        var popup = this._getPopup();

        popup.hide();

    },

    toggle: function() {

        var popup = this._getPopup();

        if(popup.isShowed())
            this.hide();
        else
            this.show.apply(this, arguments);

    },

    _getPopup : function() {

        var _this = this;

        if(!_this._calendarPopup) {
            _this._calendarPopup = $(BEMHTML.apply({
                    block : 'b-popupa',
                    mods : { theme : 'ffffff', direction : 'down' },
                    content : [
                        { elem : 'tail' },
                        { elem : 'shadow' },
                        { elem : 'content' }
                    ]
                })).bem('b-popupa');
        }

        return _this._calendarPopup;

    },

    switchMonth : function(step) {

        this._month.setUTCMonth(this._month.getUTCMonth() + step);

        this._buildCalendar();

    },

    _onChoose : function(date) {

        this._getPopup().hide();

        this.trigger('choose', date);

    },

    getCalendar : function(month) {

        var weekDay,
            weeks = [],
            week = new Array(7),
            dateIterator = new Date(month.getTime());

        for(dateIterator.setUTCDate(1); dateIterator.getUTCMonth() == month.getUTCMonth(); dateIterator.setUTCDate(dateIterator.getUTCDate() + 1)) {
            weekDay = (dateIterator.getUTCDay() + 6) % 7; // Получаем 0 - пн, 1 - вт, и т.д.

            week[weekDay] = new Date(dateIterator.getTime());

            if(weekDay == 6) {
                weeks.push(week);
                week = new Array(7);
            }
        }

        if(weekDay != 6)
            weeks.push(week);

        while(weeks.length < 6)
            weeks.push(new Array(7));

        return weeks;

    },

    _isValidDate : function(day) {

        return !(isNaN(day) || this.earlyLimit && day < this.earlyLimit || this.lateLimit && day > this.lateLimit);

    },

    _buildMonthCalendar : function(month) {

        var _this = this,
            row,
            rows = [],
            content;

        row = [];

        $.each(DAYNAMES, function(i, name) {
            var dayname = {
                elem : 'dayname',
                content : name
            };

            if(i > 4)
                dayname.mods = {
                    type : 'weekend'
                };

            row.push(dayname);
        });

        rows.push(row);

        $.each(_this.getCalendar(month), function(i, week) {
            row = [];

            $.each(week, function(i, day) {
                var off = !_this._isValidDate(day),
                    weekend = i > 4,
                    dayElem,
                    type,
                    state,
                    today;

                var js = {};

                if (day && !off) {
                    js.day = day.getTime();
                }

                dayElem = {
                    elem : 'day',
                    js : js,
                    content : day ? day.getUTCDate() : ' '
                };

                if(off || weekend)
                    type = weekend ? (off ? 'weekend-off' : 'weekend') : 'off';

                if(day && _this._selected && day.getTime() == _this._selected.getTime())
                    state = 'current';

                if(day && day.getTime() == _this.today.getTime())
                    today = 'yes';

                if(type || state || today) {
                    dayElem.mods = {};

                    if(type)
                        dayElem.mods.type = type;

                    if(state)
                        dayElem.mods.state = state;

                    if(today)
                        dayElem.mods.today = today;
                }

                row.push(dayElem);
            });

            rows.push(row);
        });

        content = [];

        $.each(rows, function(i, row) {
            content.push({
                elem: 'row',
                content: row
            });
        });

        return [
            {
                block : 'b-calendar',
                elem : 'title',
                content : [
                    {
                        elem : 'name',
                        content : MONTHNAMES[month.getUTCMonth()] + ' ' + month.getUTCFullYear()
                    }
                ]
            },
            {
                block : 'b-calendar',
                elem : 'layout',
                content : content
            }
        ];

    },

    _buildCalendar: function() {
        var _this = this,
            calendar,
            month = this._month,
            leftArrow = {
                block: 'b-icon',
                mods: { 'type': 'c-arrow-left' }
            },
            rightArrow = {
                block: 'b-icon',
                mods: { 'type': 'c-arrow-right' }
            };

        if(this.earlyLimit && monthDiff(month, this.earlyLimit) < 1) {
            leftArrow.mods.state = 'arrow-off';
            month = monthAdd(this.earlyLimit, 0);
        }

        if(this.lateLimit && monthDiff(this.lateLimit, month) < 3) {
            rightArrow.mods.state = 'arrow-off';
            month = monthAdd(this.lateLimit, -2);
        }

        calendar = $(BEMHTML.apply({
            block: 'b-calendar',
            content: [
                leftArrow,
                rightArrow,
                {
                    block: 'b-layout-table',
                    mods: { layout: '3pane' },
                    content: [
                        {
                            elem: 'cell',
                            content: this._buildMonthCalendar(month)
                        },
                        {
                            elem: 'gap'
                        },
                        {
                            elem: 'cell',
                            content: this._buildMonthCalendar(monthAdd(month, 1))
                        },
                        {
                            elem: 'gap'
                        },
                        {
                            elem: 'cell',
                            content: this._buildMonthCalendar(monthAdd(month, 2))
                        }
                    ]
                }
            ]
        })).bem('b-calendar');

        leftArrow = calendar.findBlockInside({ blockName : 'b-icon', modName : 'type', modVal : 'c-arrow-left'});
        rightArrow = calendar.findBlockInside({ blockName : 'b-icon', modName : 'type', modVal : 'c-arrow-right'});

        if(!leftArrow.hasMod('state', 'arrow-off'))
            leftArrow.bindTo('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                _this.switchMonth(-1);
            });

        if(!rightArrow.hasMod('state', 'arrow-off'))
            rightArrow.bindTo('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                _this.switchMonth(1);
            }, this);

        calendar.bindTo('day', 'click', function(e) {
            e.preventDefault();
            e.stopPropagation();

            var day = calendar.elemParams(e.data.domElem).day;

            if (day !== undefined) {
                _this._onChoose(new Date(day));
            }
        }, this);

        this._getPopup().setContent(calendar.domElem);

        return calendar;

    },

    parseDate: function(val) {

        var parsed = parseDateParts(val.replace(/ /g, ' '));

        if(parsed) {

            var day = parsed[0],
                month = parsed[1],
                year = parsed[2],
                date = new Date(this.today.getTime()),
                pastBorder = dayAdd(this.today, -30);

            date.setUTCHours(0);
            date.setUTCMinutes(0);
            date.setUTCSeconds(0);
            date.setUTCMilliseconds(0);

            date.setUTCMonth(month, day);

            if(year)
                date.setUTCFullYear(year);
            else if(date < pastBorder) {
                date.setUTCFullYear(date.getUTCFullYear() + 1);

                // Чтобы корректно отработало 29 февраля без указания года
                date.setUTCMonth(month, day);
            }


            return date;
        }

        return null;

    }
});

})();
