BEM.DOM.decl('i-clock', {

    onSetMod : {
        'js' : function() {
            this.__base.apply(this, arguments);

            var _this = this;

            function tick() {
                var format = _this.params.format,
                    time = _this.getTime(),
                    formatted,
                    delay = 1000;

                if(format == 'head') {
                    // Когда тикнуть в следущий раз (на границе минуты). Тут нам выгоднее опоздать,
                    // поэтому берем уже устаревшее время сверху.
                    delay = (60 - time.getSeconds()) * 1000;
                    _this.domElem.html(_this.formatHeadClock(time));

                } else {
                    if(time.getSeconds() % 2)
                        format = format.replace('%H:%M', '%H %M').replace('%M:%S', '%M %S');

                    formatted = BEM.blocks['i-time'].formatTime(format, time);

                    _this.domElem.html(formatted);
                }

                window.setTimeout(tick, delay);
            }

            tick();
        }
    },

    getTime: function() {

        var time = this.__self.correctTime(),
            formatted,
            offset = this.params.offset;

        time.setUTCMinutes(time.getUTCMinutes() + offset);

        return time;

    },

    formatHeadClock: function(time) {
        var formatted = BEM.blocks['i-time'].formatTime('%H:%M', time),
            bemjson = [{
                block: 'b-plate',
                mods: { separate: 'yes' },
                letter: formatted.split('')
            }],
            html = BEMHTML.apply(bemjson);

        return html;
    }

}, {
    
    correctTime : function() {
        var time = new Date();

        return new Date(time.getTime()
                        + (window.timeCorrection || 0) * 1000);
    }

});
