// Autogenerated by lib/dateparser.py, do not edit!

var charMap =  {"ё": "е", "ı": "i", "i̇": "i", "ç": "c", "ї": "i", "і": "i", "ş": "s", "ö": "o", "ü": "u", "ğ": "g"};

var stripRegexp = /^\s*(.*?)\s*$/,
    parsers,
    handlers;

parsers = [
        {
        expression: /^(\d{1,2})$/i,
        handler: 'day_handler'
    },
        {
        expression: /^(\d{1,2})[./-](\d{1,2})(?:[./-](\d{4}|\d\d))?$/i,
        handler: 'digital_handler'
    },
        {
        expression: /^(\d{4})-(\d{1,2})-(\d{1,2})(?:\s(\d{2}):(\d{2}):(\d{2}))?$/i,
        handler: 'ansi_handler'
    },
        {
        expression: /^(\d{1,2})\s*((?:янв|квiтень|авг|сiчня|июл|ноя|июн|июля|июль|березень|лютого|фев|августа|март|вересень|липень|haz|грудень|жовтня|eylul|листопад|черв|грудня|agustos|январь|листопада|января|сiч|tem|ara|kasim|сен|temmuz|sub|лип|mayis|квiт|сiчень|травня|червня|серпня|апрель|апреля|квiтня|жовт|липня|дек|aralik|серп|серпень|eyl|ocak|mart|октябрь|октября|сентября|травень|сентябрь|вересня|ноябрь|окт|лист|трав|червень|nisan|ноября|вер|груд|haziran|березня|ekim|subat|апр|февраля|февраль|август|июнь|июня|лютий|май|лют|жовтень|мая|марта|may|мар|kas|nis|декабря|декабрь|бер|agu))(?:\s+(\d{4}|\d\d))?$/i,
        handler: 'human_handler'
    },
        {
        expression: /^(вчора|yarin|bugun|на\s+всi\s+днi|bir\s+hafta\s+sonra|через\s+тиждень|tum\s+gunler\s+icin|вчера|сегодня|yarindan\s+sonraki\s+gun|на\s+все\s+дни|dunden\s+onceki\s+gun|через\s+мiсяць|завтра|bir\s+ay\s+sonra|через\s+неделю|послезавтра|пiслязавтра|сьогоднi|dun|yarindan\s+sonra|через\s+месяц|позавчора|позавчера)$/i,
        handler: 'human_pointer_handler'
    },
        {
        expression: /^(persembe|cumartesi|суббота|pazar|недiля|воскресенье|четверг|carsamba|п'ятниця|пятница|субота|sali|среда|cuma|вiвторок|четвер|вторник|понедельник|понедiлок|середа|pazartesi)$/i,
        handler: 'human_weekday_handler'
    }
];

handlers = {
    'human_handler': function (day, month, year) {
        // Месяц правильный подразумевается из регекспа
        if(day < 1 || day > 31) {
            return false;
        }

        return true;
    },
    'digital_handler': function (day, month, year) {
        if(day < 1 || day > 31 || month < 1 || month > 12) {
            return false;
        }

        return true;
    }
}

function checkDate(value) {
    var i,
        result,
        variants;

    // Убираем пробелы в начале и конце
    value = stripRegexp.exec(value)[1];

    // IE<9 не воспринимает неразрывный пробел как \s
    value = value.replace(/\u00a0/g, ' ');

    $.each(charMap, function(k, v) {
        value = value.split(k).join(v);
    });

    variants = [value];

    // Варинты с коррекцией раскладки
    Array.prototype.push.apply(variants, puntoVariants(value));

    for(i = 0; i < variants.length; i++) {
        result = _checkDate(variants[i]);

        if (result) {
            return true;
        }
    }

    return false;
}

function _checkDate(value) {
    // Проходим по всем регулярным выражениям, если какое-то совпадает,
    // значит формат даты - известен
    for(var i = 0; i < parsers.length; i++) {
        var parser = parsers[i],
            match = parser.expression.exec(value);

        if(match) {
            if(parser.handler in handlers) {
                return handlers[parser.handler].apply(null, match.slice(1));
            } else {
                return true;
            }
        };
    }

    return false;
};

var enKeys = "qwertyuiop[{]}asdfghjkl;:\'\"zxcvbnm,<.>`"; // enKeys длиннее из-за экранирования (\)
var ruKeys = "йцукенгшщзххъъфывапролджжээячсмитьббююё";
var ukKeys = "йцукенгшщзххїїфівапролджжєєячсмитьббююё";

function puntoVariants(value) {
    var i, j, k,
        baseKeysSet = [enKeys],
        baseKeys,
        localKeysSet = [ruKeys, ukKeys],
        localKeys,
        variants = [];

    function convert(fromKeys, toKeys) {
        var i,
            converted = value;

        for(i = 0; i < fromKeys.length; i++) {
            converted = converted.split(fromKeys.charAt(i)).join(toKeys.charAt(i));
        }

        variants.push(converted);
    }

    for(i = 0; i < baseKeysSet.length; i++) {
        baseKeys = baseKeysSet[i];

        for(j = 0; j < localKeysSet.length; j++) {
            localKeys = localKeysSet[j];

            convert(baseKeys, localKeys);
            convert(localKeys, baseKeys);
        }
    }

    return variants;
}
