#!/bin/bash

set -e

. debian/vars.sh

destdir=debian/markup-built

long=$(git rev-parse HEAD)
short=$(git rev-parse --short HEAD)
pkg_version=3.$short

build_branch=build-$short-branch
build_tag=build-$long

remote=${REMOTE:-origin}

git fetch --tags $remote
git push --tags $remote

while read tag; do
    if [[ $tag = $build_tag ]]; then
        echo "Tag exists, assuming markup is built, checking it out"
        git checkout $build_tag
        exit
    fi
done < <(git tag -l)

git fetch

git checkout -b $build_branch

echo $pkg_version > debian/markup-version

debian/copyrepo.py . $destdir

rm -rf $destdir/debian

(
    cd $destdir

    sed "s/@@PKG_VERSION@@/$pkg_version/" -i configs/production/ycssjs

    make YENV=production

    for page in $STANDALONE_PAGES; do
        ycssjs --once=yes --minimize=yes --freeze=yes pages-desktop/$page/$page.{css,ie*.css}
    done

    find . -depth -name ".svn" -exec rm -rf \{\} \;

    # Чтобы добавить все собранные файлы, удаляем .gitignore
    find . -name ".gitignore" -delete
)

git add --all $destdir
git add debian/markup-version

git commit -m "Build $pkg_version"

git push -u $remote $build_branch:$build_branch

git tag $build_tag

git push --tags $remote
