#!/bin/bash

set -e

function is_deployed {
    curl -s https://c.yandex-team.ru/api/package_version/yandex-rasp-static-?branch=stable | grep -qF '"'"$pkg_version"'"'
}

pkg_version=$(< debian/markup-version)

if is_deployed; then
    echo Пакет yandex-rasp-static-=$pkg_version уже в stable
    exit
fi

conductor-ticket --branch stable --oauth $ROBOT_CONDUCTOR_OAUTH_TOKEN yandex-rasp-static-=$pkg_version
