# coding: utf-8

import logging
import re
import cookiemy
import urllib
from urlparse import urlparse

import uatraits
from django.http import HttpResponseRedirect
from django.conf import settings

from url_mapper import RaspMapper, UrlMappingError

from travel.rasp.morda.morda.views import tinyurl


log = logging.getLogger(__name__)


def get_mobile_version_url(request):
    if request.META['PATH_INFO'].startswith('/-/'):
        url = tinyurl.restore(request, request.META['PATH_INFO'][3:])

        url = url.replace('span=schedule', 'filter=all').\
                            replace('span=day', 'filter=today').\
                            replace('event=arrival', u'direction=прибытие').\
                            replace('event=departure', u'direction=отправление')
        res = urlparse(url)

        return u'https://m.{host}{path}{qs}'.format(
            host=res.netloc, path=res.path,
            qs=res.query and u'?' + res.query or u''
        )

    return u'https://m.{host}{path}{qs}'.format(
        host=request.META['HTTP_HOST'],
        path=request.META['PATH_INFO'],
        qs=request.META['QUERY_STRING'] and u'?' + request.META['QUERY_STRING'].decode('utf8') or u''
    )


def get_touch_version_url(request):
    mapper = RaspMapper(settings.DOMAIN_TO_TOUCH_NATIONAL_VERSION.get(request.tld, settings.TOUCH_DOMAIN))

    rasp_url = 'https://%s%s' % (settings.DOMAIN_NAME, request.get_full_path())

    try:
        return mapper.get_touch_url(rasp_url)

    except UrlMappingError:
        pass


class MobileRedirect:
    """RASP-4456"""
    DISABLE_FOR_RE = re.compile('(^/(api|knobs|export|informers|o14|O14|014|info)/)|nearest|prefill|mobile_suggests|promo|(^/(fi|fin|finland)$)')
    FULL_VERSION_PRIORITY_ID = 44 # http://wiki.yandex-team.ru/MyCookie/NomerBloka

    MOBILE_VERSION_DOMAINS = ['ru', 'by', 'kz', 'uz', 'ua' ]

    def preferred_version(self, request):
        try:
            cookie = urllib.unquote(request.COOKIES['my'])
            setup = cookiemy.Setup()
            setup.parse(cookie)

        except (KeyError, RuntimeError):
            return None

        choose = setup.find(self.FULL_VERSION_PRIORITY_ID)

        if choose:
            return {0: 'mobile', 1: 'full'}.get(choose[0])

    def process_request(self, request):
        request.touch_version_url = get_touch_version_url(request)

        request.mobile_version_url = get_mobile_version_url(request)

        if settings.DISABLE_PHD or 'HTTP_USER_AGENT' not in request.META:
            return

        preferred_version = self.preferred_version(request)

        detector = uatraits.detector('/usr/share/uatraits/browser.xml')

        res = detector.detect(request.META['HTTP_USER_AGENT'])

        host = request.META.get('HTTP_HOST', 'rasp.yandex.ru')

        if preferred_version == 'full' or not res['isMobile'] or 'ticket' in host:  # MOBRASP-459
            log.debug('No redirect')

            return

        if request.tld not in self.MOBILE_VERSION_DOMAINS:
            return

        if self.DISABLE_FOR_RE.search(request.path):
            return

        if res.get('isTouch') and settings.ENABLE_TOUCH_REDIRECT and res.get('BrowserName') != 'OperaMini':
            except_regexp = re.compile('^/(fi|fin|finland)/?$')

            if except_regexp.search(request.path):  # не редиректим со страницы финского промо
                return

            if request.touch_version_url:
                log.debug('Redirect to touch version')
                return HttpResponseRedirect(request.touch_version_url)
            return

        # https://st.yandex-team.ru/RASPFRONT-10014
        # log.debug('Redirect to mobile version')

        return
