#-*- coding: utf-8 -*-

import logging
import urllib
from urlparse import urlsplit, urlunsplit

from django.http import HttpResponseRedirect
from django.conf import settings

from common.models.schedule import Supplier
from common.utils import marketstat, request_helper
from common.utils.mysql_try_hard import mysql_try_hard

from travel.rasp.morda.morda.order.forms import OrderSegmentForm, ExtraSegmentForm
from travel.rasp.morda.morda.order.views.partners.main import PARTNER_MODULES
from travel.rasp.morda.morda.order.views.redirect import mail_error, redirect_by_url, PostRedirect
from travel.rasp.morda.morda.templates.order.error import PartnerRedirectError, bad_link_error

log = logging.getLogger(__name__)
redir_log = marketstat.Log(settings.BUS_REDIR_LOG)


ORDER_FUNCTIONS = {
    key: module.order for key, module in PARTNER_MODULES.iteritems() if hasattr(module, 'order')
}


def add_openstat_marker(request, partner, redirection):
    def add_marker(location):
        o = urlsplit(location)
        marker = u"rasp.yandex.ru;%s;Купить билет на автобус;%s" % (partner, request_helper.get_host(request))
        query = (o.query + '&' if o.query else '') + '_openstat=' + urllib.quote(marker.encode('utf-8'))
        return urlunsplit((o.scheme, o.netloc, o.path, query, o.fragment))

    if partner == 'Ecolines-xml':
        return

    if isinstance(redirection, HttpResponseRedirect):
        redirection["Location"] = add_marker(redirection["Location"])
    elif isinstance(redirection, PostRedirect):
        redirection.location = add_marker(redirection.location)


@mysql_try_hard
def redirect(request):
    order_form = OrderSegmentForm(request.GET)

    if not order_form.is_valid():
        order_form = ExtraSegmentForm(request.GET)

        if not order_form.is_valid():
            log.debug(repr(order_form.errors))

            return bad_link_error(request)

    if not order_form.cleaned_data['choice']:
        log.debug('no choice')

        return bad_link_error(request)

    data = order_form.cleaned_data

    try:
        supplier_code = data['choice']['supplier']

    except KeyError:
        if settings.DEBUG:
            raise

        return bad_link_error(request)

    try:
        redirection = ORDER_FUNCTIONS.get(supplier_code, redirect_by_url)(request, data)

        if isinstance(redirection, HttpResponseRedirect):
            uri = redirection['Location']

        elif isinstance(redirection, tuple):
            uri, redirection = redirection

        else:
            uri = request_helper.build_absolute_uri(request)

        supplier = Supplier.objects.get(code=supplier_code)

        redir_data = {
            'supplier_id': supplier.id,
            'url': uri,
            'host': 'rasp',
        }

        show_id = data['choice'].get('show_id', None)

        if show_id:
            redir_data['show_id'] = show_id

        redir_log.log(request, redir_data)

        add_openstat_marker(request, data['choice']['supplier'], redirection)

        return redirection

    except Exception, e:
        if settings.DEBUG:
            raise

        log.exception('')
        mail_error(e)

        return PartnerRedirectError.render(request)
