# -*- coding: utf-8 -*-

from datetime import timedelta

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.redirect import PostRedirect


AVPERM_URL = u'http://avperm.ru/buyticket/'


def can_buy_from(request, supplier_code, can_buy_context):
    order_data = can_buy_context['order_data']
    if not order_data:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    try:
        max_days_from_now = int(order_data['day_sale'])

        return now + timedelta(hours=2) < segment_departure < now + timedelta(days=max_days_from_now)

    except (KeyError, ValueError):
        return False


def get_price_data(segment):
    order_data = {
        'supplier': 'avperm',
        'partner': 'avperm',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'avperm_click',
    }


def order(request, order_data):
    segment = order_data['segment']

    data = order_data['choice']

    params = {
        'y_date_raice': segment.departure.strftime('%Y-%m-%d'),
        'y_id_shablon': data['id_shablon'],
        'y_time_out': data['start_time'],
        'y_id_marshrut': data['route_code'],
        'price_raice': data['station_price'],
        'price_raice_child': data['station_price'],
        'stopplace_choose': data['station_title'],
        'awt': data['code_awt'],
    }

    response = PostRedirect(AVPERM_URL, params)
    response['Content-type'] = 'text/html; charset=utf-8'

    return response
