# -*- coding: utf-8 -*-

from datetime import timedelta

from travel.rasp.library.python.common23.date import environment

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.partners.utils import get_number_of_days_to_departure
from travel.rasp.morda.morda.order.views.redirect import PostRedirect


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    return now + timedelta(hours=4, minutes=5) < segment_departure < now + timedelta(days=30)


def get_price_data(segment):
    order_data = {
        'supplier': 'Donavto',
        'partner': 'Donavto',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'donavto_click',
    }


def order(request, order_data):
    segment = order_data['segment']

    data = order_data['choice']

    n_days = get_number_of_days_to_departure(environment.now_aware(), segment.departure)

    params = {
        'pfrom': data['station_from_code'],
        'pto': data['station_to_code'],
        'pdate': str(n_days),
    }

    response = PostRedirect(u'http://www.donbilet.ru/main', params)
    response['Content-type'] = 'text/html; charset=utf-8'

    return response
