# -*- coding: utf-8 -*-

from travel.rasp.library.python.common23.date import environment
from common.utils.date import to_unix_timestamp

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.redirect import PostRedirect


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    return now <= segment_departure


def get_price_data(segment):
    order_data = {
        'supplier': 'Ecolines-xml',
        'partner': 'Ecolines-xml',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'ecol_click',
    }


def order(request, order_data):
    segment = order_data['segment']

    departure = segment.departure

    data = order_data['choice']

    params = {
        # timestamp, первое число месяца и года перевозки
        'monyear1': str(to_unix_timestamp(environment.now().replace(day=1, hour=0, minute=0, second=0)) + 7200),
        # число, месяц и год перевозки
        'depdate': str(to_unix_timestamp(departure.replace(hour=0, minute=0, second=0)) + 7200),
        # число обратной перевозки, не используем
        'retdata': '',
        #  id станция отправления, с символом a в начале
        'citydep': u'a%s' % data['station_from_code'],
        #  id станции прибытия
        'cityarr': u"%s" % data['station_to_code'],
        # количество пассажиров
        's': '1',
        # шаг, всегда передаём 3
        'nextstep': '3',
        # всегда передаем 0
        'tvar': '0'
    }

    response = PostRedirect(u'http://legacy.ecolines.net/index.php?s=55', params)
    response['Content-type'] = 'text/html; charset=utf-8'

    return response
