# -*- coding: utf-8 -*-

from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.partners.utils import get_number_of_days_to_departure


INFOBUS_URL = 'http://www.infobus.eu/booking?'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    return 1 <= get_number_of_days_to_departure(now, segment_departure) <= 14


def get_price_data(segment):
    order_data = {
        'supplier': 'infobus',
        'partner': 'infobus',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'infobus_click',
    }


def order(request, order_data):
    segment = order_data['segment']

    data = order_data['choice']

    params = {
        'point_from_id': data['station_from_code'],
        'point_to_id': data['station_to_code'],
        'date': segment.departure.strftime('%d.%m.%Y'),
        'currency': 'RUB',
        'only': 'bus',
        'lang': 'ru',
        'partner': '1222',
    }

    url = INFOBUS_URL + urlencode(params)

    return HttpResponseRedirect(url)
