# -*- coding: utf-8 -*-

from datetime import timedelta
from hashlib import md5

from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.rasp.library.python.common23.date import environment

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.partners.utils import get_number_of_days_to_departure
from travel.rasp.morda.morda.order.views.redirect import PostRedirect


KVC_TULA_BUY_URL = 'http://www.biletnaavto.ru/sbus_server/y_gateway.php'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    is_good_date = (1 <= get_number_of_days_to_departure(now, segment_departure) <= 14)

    return is_good_date and now + timedelta(hours=6) < segment_departure


def get_price_data(segment):
    order_data = {
        'supplier': 'kvc_tula',
        'partner': 'kvc_tula',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'tkvc_click',
    }


def order(request, order_data):
    data = order_data['choice']

    segment = order_data['segment']

    departure = segment.departure

    params = [
        ('awtCode', data['av_code'].encode('cp1251')),
        ('station', data['station_title'].encode('cp1251')),
        ('dateRaice', departure.strftime('%d.%m.%Y')),
        ('timeRaice', departure.strftime('%H:%M')),
    ]

    params.append(('key', md5(''.join(value for name, value in params)).hexdigest()))

    url = KVC_TULA_BUY_URL + '?' + urlencode(params)

    return HttpResponseRedirect(url)
