# -*- coding: utf-8 -*-

import random
from datetime import timedelta, datetime

import pytz

from common.models.schedule import RTStation

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.redirect import PostRedirect


MRTRANS_ORDER_URL = 'http://www.mrtrans.ru/?page=searchroutes'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    start_from = (now + timedelta(hours=3))
    end_with = (now + timedelta(46)).replace(hour=0, minute=0, second=0)

    return start_from <= segment_departure < end_with


def get_price_data(segment):
    # RASP-9437

    # Порядковый номер станции отправления данного рейса в городе отправления
    position = 0

    rtstations = RTStation.objects.filter(
        thread=segment.thread,
        id__lt=segment.rtstation_from.id
    ).exclude(
        id=segment.rtstation_from.id
    ).order_by('-id')

    for rtstation in rtstations:
        if rtstation.station.settlement != segment.rtstation_from.station.settlement:
            break

        position += 1

    begining_of_the_epoch = pytz.UTC.localize(datetime(1970, 1, 1))

    departure_timestamp = str(int((segment.departure - begining_of_the_epoch).total_seconds()))
    arrival_timestamp = str(int((segment.arrival - begining_of_the_epoch).total_seconds()))

    naive_start_dt = datetime.combine(segment.start_date, segment.thread.tz_start_time)
    start_dt = segment.thread.pytz.localize(naive_start_dt)
    start_timestamp = str(int((start_dt - begining_of_the_epoch).total_seconds()))

    from_title = (
        segment.station_from.settlement and
        segment.station_from.settlement.title or segment.station_from.title
    )

    from_title = from_title.replace('(', ',').split(',')[0].strip()

    to_title = (
        segment.station_to.settlement and
        segment.station_to.settlement.title or segment.station_to.title
    )

    to_title = to_title.replace('(', ',').split(',')[0].strip()

    order_data = {
        'supplier': 'mrtrans',
        'partner': 'mrtrans',  # Для счётчика покупок
        'show_id': show_id(0),
        'from': from_title,
        'to': to_title,
        'date': segment.departure.astimezone(segment.station_from.pytz).strftime('%d.%m.%Y'),
        'vuser': '1',
        'rate': segment.thread.hidden_number,
        'obtime': start_timestamp,
        'btime': departure_timestamp,
        'etime': arrival_timestamp,
        'position': position,
        'transaction': datetime.now().strftime('%s') + str(random.randint(10000000, 99999999)),
    }

    return {
        'order_data': order_data,
        'click': 'mrtrans_click',
    }


def order(request, order_data):
    def dict_slice(d, keys):
        return dict([(k, d[k]) for k in keys if k in d])

    params = {'yandex_step': '1',
              'c1user': '0',
              'c2user': '0'}
    params.update(dict_slice(
        order_data['choice'],
        ['from', 'to', 'date', 'vuser', 'rate', 'position', 'obtime', 'btime', 'etime', 'transaction']))

    response = PostRedirect(MRTRANS_ORDER_URL, params)
    response['Content-type'] = 'text/html; charset=windows-1251'

    return response
