# -*- coding: utf-8 -*-

from datetime import timedelta

from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.partners.utils import get_number_of_days_to_departure


TAKEBUS_URL = 'http://takebus.ru/avtobus/YaScheduale?'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    if get_number_of_days_to_departure(now, segment_departure) <= 30:
        if now + timedelta(minutes=60) < segment_departure:
            return True

    return False


def get_price_data(segment):
    order_data = {
        'supplier': 'takebus',
        'partner': 'takebus',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'takebus_click',
    }


def order(request, order_data):
    segment = order_data['segment']
    data = order_data['choice']

    params = {
        'station_to_code': data['station_to_code'].lstrip('0'),
        'station_from_code': data['station_from_code'].lstrip('0'),
        'date': segment.departure.strftime('%Y-%m-%d'),
        'time': segment.departure.strftime('%H-%M'),
        'api': 'mosgor',
    }

    url = TAKEBUS_URL + urlencode(params)

    return HttpResponseRedirect(url)

