# -*- coding: utf-8 -*-

from datetime import timedelta
from django.utils.http import urlencode
from django.http import HttpResponseRedirect

from travel.rasp.morda.morda.order.utils import show_id


"""
https://st.yandex-team.ru/RASPADMIN-527
"""

ORDER_URL = 'http://avtovokzal-on-line.ru/ya/redir'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    too_late = (can_buy_context['segment'].departure - can_buy_context['now']) < timedelta(hours=3)
    too_early = (can_buy_context['segment'].departure - can_buy_context['now']) > timedelta(days=14)

    return not (too_early or too_late)


def get_price_data(segment):
    order_data = {
        'supplier': 'utisauto',
        'partner': 'utisauto',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'utisauto_click',
    }


def order(request, order_data):
    segment = order_data['segment']
    data = order_data['choice']

    params = {
        'dispatch_station_id': data['station_from_code'],
        'arrival_station_id': data['station_to_code'],
        'date': segment.departure.strftime('%Y-%m-%d'),
        'time': segment.departure.strftime('%H:%M'),
    }

    url = ORDER_URL + '?' + urlencode(params)

    return HttpResponseRedirect(url)
