# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf.urls import url

from travel.rasp.morda.morda.redirects.views import redirect_to, security_scanner_proxy


urlpatterns = [
    url(r'^partners$', redirect_to, {'url': '/info/partners'}),
    url(r'^tablo/station/(?P<station_id>\d+)', redirect_to, {'url': '/station/%(station_id)s/'}),
    url(r'^map/trains$', redirect_to, {'url': '/map/trains/'}),
    url(r'^map', redirect_to, {'url': '/map/air/'}),

    # Фейковые урлы для сканера безопасности RASP-5676
    url(r'^ss/typed_search', security_scanner_proxy, {'handler': 'search.main'}),
    url(r'^ss/thread', security_scanner_proxy, {'handler': 'thread.thread'}),
    url(r'^ss/city', security_scanner_proxy, {'handler': 'city.main'}),
    url(r'^ss/gorod', security_scanner_proxy, {'handler': 'city.main'}),
    url(r'^ss/station', security_scanner_proxy, {'handler': 'station.station', 'param': 'station_id'}),
    url(r'^ss/station_esr', security_scanner_proxy, {'handler': 'station.station_esr', 'param': 'esr_code'}),
    url(r'^ss/city_directions', security_scanner_proxy, {'handler': 'city.direction'}),
    url(r'^ss/widget_tablo', security_scanner_proxy, {'handler': 'station.widget_tablo'}),
]
