# -*- coding: utf-8 -*-

from django.core.urlresolvers import get_callable
from django.http import HttpResponseRedirect, HttpResponsePermanentRedirect, Http404


TICKET_CLID = 2289669


def redirect_to(request, url, **params):
    host_path = (url % params).encode('utf-8')
    query = request.META['QUERY_STRING']

    redirect_url = host_path

    if query:
        redirect_url += '?' + query

    return HttpResponsePermanentRedirect(redirect_url)


def security_scanner_proxy(request, handler, param=None):
    u"Вьюха, транслирующая специальные урлы сканера безопасности в нормальные вьюхи"
    view = get_callable('www.views.' + handler)
    if param:
        return view(request, **{param:request.GET['id']})
    else:
        return view(request, request.GET['id'])
