# -*- coding: utf-8 -*-

from datetime import timedelta
from common.models.tariffs import Setting
from common.xgettext.i18n import mark_gettext


def can_buy_from(supplier, info, client_city, today_plane, time_left, point_from, point_to):
    if supplier == 'agent':
        return info.et_possible

    if supplier == 'ozon':
        return time_left is None or time_left > timedelta(hours=12)

    if supplier == 'pososhok':
        return not today_plane

    if supplier == 'biletall':
        # RASP-12541
        return time_left and not time_left < timedelta(hours=3)

    # RASPFRONT-1193: показывать кнопку УФС если станция отправления ИЛИ станция прибытия в России
    if supplier == 'ufs':
        if point_from and point_from.country and point_from.country.code == 'RU':
            return True

        if point_to and point_to.country and point_to.country.code == 'RU':
            return True

        return False

    return True


# Имена классов для отображения, в порядке отображения
# Закомментированные отображать не нужно
CLS_MAPPING = [
    (mark_gettext(u'СВ'), 'suite'),
    (mark_gettext(u'купе'), 'compartment'),
    (mark_gettext(u'плацкарт'), 'platzkarte'),
    (mark_gettext(u'сидячие'), 'sitting'),
    (mark_gettext(u'общий'), 'common'),
    #(mark_gettext(u'М'), 'soft'),

    (mark_gettext(u'бизнес'), 'business'),
    (mark_gettext(u'эконом'), 'economy'),

    # автобусы
    (u'', 'bus'),
]


ORDER_CLS_MAPPING = [
    ('common', mark_gettext(u'общий')),
    ('sitting', mark_gettext(u'сидячие')),
    ('platzkarte', mark_gettext(u'плацкарт')),
    ('compartment', mark_gettext(u'купе')),
    ('compartment_min', mark_gettext(u'купе')),
    ('compartment_max', mark_gettext(u'купе эконом-класса')),
    ('suite', mark_gettext(u'люкс (СВ)')),
    ('soft', mark_gettext(u'мягкие')),

    # Самолеты
    ('economy', mark_gettext(u'эконом')),
    ('business', mark_gettext(u'бизнес')),
    ('first', mark_gettext(u'первый')),
]

CLS_NAMES = dict(ORDER_CLS_MAPPING)


def ufs_cache_timeout():
    """
    Время жизни кеша УФС (сек.)
    """
    return Setting.get('UFS_CACHE_TIMEOUT') * 60


def ufs_empty_timeout():
    """
    Время жизни кеша УФС для пустых результатов и ошибок (сек.)
    """
    return Setting.get('UFS_EMPTY_TIMEOUT') * 60


def ufs_network_error_timeout():
    """
    Время жизни кеша УФС для сетевых, HTTP, SSL ошибок (сек.)
    """
    return Setting.get('UFS_NETWORK_ERROR_TIMEOUT') * 60


def ufs_response_error_timeout():
    """
    Время жизни кеша когда УФС возвращает ошибку (сек.)
    """
    return Setting.get('UFS_RESPONSE_ERROR_TIMEOUT') * 60


def ufs_parse_error_timeout():
    """
    Время жизни кеша, когда ошиблись при разборе ответа от УФС (сек.)
    """
    return Setting.get('UFS_PARSE_ERROR_TIMEOUT') * 60
