# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.utils.bemhtml import punctuate_content
from common.xgettext.i18n import gettext, xgettext, xformat

# Шаблоны
from travel.rasp.morda.morda.templates.base import Base


class Template(Base):
    page = 'precise'

    def b_precise_list(self, direction):
        cities = self.context['airports_%s' % direction]

        def item(data):
            variants = None

            city, airports = data

            if len(airports) == 1:
                point = airports[0]

            else:
                point = city

                variants = [
                    xgettext(u"а/п <airport-title/>", airport_title={
                        'block': 'b-link',
                        'url': self.change_params(**{
                            '%sName' % direction: a.L_title(),
                            '%sId' % direction: a.point_key,
                        }),
                        'content': a.L_title()
                    })

                    for a in airports
                ]

            return {
                'elem': 'item',
                'content': [
                    {
                        'elem': 'station',
                        'content':  [
                            {
                                'block': 'b-link',
                                'url': self.change_params(**{
                                    '%sName' % direction: point.L_title(),
                                    '%sId' % direction: point.point_key,
                                }),
                                'content': xgettext('г. <city-title/>', city_title=city.L_title)
                            },

                            variants and [' (', punctuate_content(variants), ')']
                        ]
                    }
                ]
            }

        return {
            'block': 'b-precise-list',
            'content': map(item, cities)
        }

    def l_precise(self):
        lang = get_language()

        return {
            'block': 'l-precise',
            'content': [
                self.context.airports_from and {
                    'elem': 'column',
                    'mods': {'display': 'inline'},
                    'content': [
                        {
                            'block': 'b-precise-title',
                            'content': {
                                'tag': 'strong',
                                'content': xformat('Пожалуйста, уточните пункт отправления <country-title case="phrase_in"/>:', country_title=self.context.airports_from_country.L_title) if lang == 'ru' else gettext('Пожалуйста, уточните пункт отправления:')
                            }
                        },
                        self.b_precise_list('from'),
                    ]
                },
                self.context.airports_to and {
                    'elem': 'column',
                    'mods': {'display': 'inline'},
                    'content': [
                        {
                            'block': 'b-precise-title',
                            'content': {
                                'tag': 'strong',
                                'content': xformat('Пожалуйста, уточните пункт прибытия <country-title case="phrase_in"/>:', country_title=self.context.airports_to_country.L_title) if lang == 'ru' else gettext('Пожалуйста, уточните пункт прибытия:')
                            }
                        },
                        self.b_precise_list('to'),
                    ]
                }
            ]
        }

    def content(self):
        return {
            'block': 'l-page',
            'mods': { 'layout': '72-20' },
            'content': {
                'elem': 'row',
                'content': [
                    { 'elem': 'gap' },
                    {
                        'elem': 'left',
                        'content': self.l_precise(),
                    },
                    { 'elem': 'right' },
                    { 'elem': 'gap' }
                ]
            }
        }
