# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.utils.bemhtml import punctuate_content
from common.xgettext.i18n import gettext

# Шаблоны
from travel.rasp.morda.morda.templates.base import Base


class Template(Base):
    page = 'precise'

    def b_precise_list(self, direction):
        field = self.context.form.cleaned_data[direction]

        has_variants = field.has_variants()

        def item(variant):
            omonim_title = variant.L_omonim_title_bem(self.context.request, direction)

            title = omonim_title['title']

            current = not has_variants and variant == field.point

            if not current:
                title = {
                    'block': 'b-link',
                    'url': self.change_params(**{
                        '%sName' % direction: variant.L_title(),
                        '%sId' % direction: variant.point_key,
                        'suggest': None
                    }),
                    'content': title
                }

            add = omonim_title.get('add')

            return {
                'elem': 'item',
                'elemMods': { 'state': current and 'current' },
                'content': [
                    { 'elem': 'station', 'content': title },
                    add and [' ', { 'elem': 'place', 'content': ['(', punctuate_content(add), ')' ] } ]
                ]
            }

        return {
            'block': 'b-precise-list',
            'content': map(item, field.variants)
        }

    def l_precise(self):
        return {
            'block': 'l-precise',
            'content': [
                {
                    'elem': 'column',
                    'elemMods': { 'display': 'inline' },
                    'content': [
                        {
                            'block': 'b-precise-title',
                            'content': gettext('Пожалуйста, уточните<br><strong>место отправления:</strong>')
                        },
                        self.b_precise_list('from'),
                    ]
                },
                {
                    'elem': 'column',
                    'elemMods': { 'display': 'inline' },
                    'content': [
                        {
                            'block': 'b-precise-title',
                            'content': gettext('Пожалуйста, уточните<br><strong>место прибытия:</strong>')
                        },
                        self.b_precise_list('to'),
                    ]
                }
            ]
        }

    def content(self):
        return {
            'block': 'l-page',
            'mods': { 'layout': '72-20' },
            'content': {
                'elem': 'row',
                'content': [
                    { 'elem': 'gap' },
                    {
                        'elem': 'left',
                        'content': self.l_precise(),
                    },
                    { 'elem': 'right' },
                    { 'elem': 'gap' }
                ]
            }
        }
