# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext, dynamic_gettext


class BlockFilter(object):
    def __init__(self, base):
        self.base = base

        data = base.context.filters

        self.filters = data.filters
        self.ordered = data.ordered

    def item_content_simple(self, f):
        return {
            'block': 'b-menu-vert-mod',
            'mods': { 'type': 'submenu' },
            'content': [
                {
                    'elem': 'item',
                    'hidden': bool(hidden),
                    'content': {
                        'block': 'b-form-checkbox',
                        'mods': { 'theme': 'grey-m', 'size': 'm', 'checked': checked },
                        'checkboxAttrs': { 'name': f.param_name, 'value': o.value },
                        'content': { 'elem': 'label', 'content': dynamic_gettext(o.name), 'attrs': { 'title': o.tooltip } if o.tooltip else {} }
                    }
                } for o, checked, hidden in f
            ]
        }

    def item(self, f):
        item_content = getattr(self, 'item_content_%s' % f.template)(f)

        return {
            'elem': 'item',
            'hidden': bool(not f.active),
            'content': {
                'block': 'b-link',
                'mods': { 'pseudo': 'yes', 'inner': 'yes' },
                'mix': [
                    {
                        'block': 'b-menu-vert-mod',
                        'elem': 'trigger',
                        'mods': { 'state': 'opened' if f.opened else None },
                    }
                ],
                'content': [
                    {
                        'block': 'b-icon',
                        'mix': [{ 'block': 'b-menu-vert-mod', 'elem': 'trigger-icon' }],
                        'alt': '+'
                    },
                    { 'elem': 'inner', 'content': dynamic_gettext(f.name) }
                ]
            },
            'item-content': {
                'elem': 'item-content',
                'mods': { 'visibility': 'visible' if f.opened else None },
                'mix': [{ 'block': 'b-filter', 'elem': 'filter', 'js': f.data } ],
                'content': item_content
                # {
                #     'block': 'b-time-filter',
                #     'content': {
                #         'block': 'b-menu-vert-mod',
                #         'mods': { 'type': 'submenu', 'preset': 'time-filter' },
                #         'content': [
                #             {
                #                 'elem': 'item',
                #                 'content': {
                #                     'block': 'b-menu-horiz',
                #                     'mods': { 'layout': 'complex', 'preset': 'time-filter' },
                #                     'content': [
                #                         {
                #                             'elem': 'item',
                #                             'content': {
                #                                 'block': 'b-form-input',
                #                                 'mods': { 'size': 'm', 'theme': 'grey' },
                #                                 'content': [
                #                                     { 'elem': 'hint', 'content': '18:00' },
                #                                     { 'elem': 'input' }
                #                                 ]
                #                             }
                #                         },
                #                         { 'elem': 'gap' },
                #                         {
                #                             'elem': 'item',
                #                             'content': {
                #                                 'block': 'b-form-input',
                #                                 'mods': { 'size': 'm', 'theme': 'grey' },
                #                                 'content': [
                #                                     { 'elem': 'hint', 'content': '22:00' },
                #                                     { 'elem': 'input' }
                #                                 ]
                #                             }
                #                         }
                #                     ]
                #                 }
                #             }
                #         ]
                #     }
                # }
            }
        }

    def __json__(self):
        hidden = not any(f.active for f in self.ordered)

        return {
            'tag': 'noindex',
            'content': [
                {
                    'block': 'b-filter-title',
                    'mix': [hidden and { 'block': 'i-hidden' }],
                    'content': gettext('Поиск рейса по параметрам')
                },
                {
                    'block': 'b-filter',
                    'js': True,
                    'mix': [hidden and { 'block': 'i-hidden' }],
                    'content': {
                        'elem': 'form',
                        'content': {
                            'elem': 'content',
                            'content': [
                                {
                                    'block': 'b-menu-vert-mod',
                                    'js': True,
                                    'mods': { 'preset': 'filter' },
                                    'content': [
                                        self.item(f) for f in self.ordered
                                    ]
                                }
                            ]
                        }
                    }
                }
            ]
        }
