# -*- coding: utf-8 -*

from __future__ import unicode_literals

from common.xgettext.i18n import gettext

from travel.rasp.morda.morda.templates.maps.trains import Template as Base


class Template(Base):
    DATA_PREFIX = '/maps/bus/'

    def get_title(self):
        return gettext('Автобусики')

    def get_disclaimer(self):
        return gettext('Местоположение автобусов рассчитано на основе расписания рейсов.')

    def get_not_found_message(self):
        return gettext('По вашему запросу автобусики не&nbsp;найдены. Попробуйте изменить параметры поиска.')

    def b_maps_search(self):
        return {
            'block': 'b-maps-search',
            'mods': {'type': 'trains'},
            'js': {'center': self.context.map.center,
                   'zoom': self.context.map.zoom},
            'attrs': {'action': '#', 'method': 'get'},
            'content': [
                {
                    'block': 'b-form-input',
                    'mods': {
                        'size': 'm',
                        'theme': 'grey',
                        'has-clear': 'yes',
                        'autocomplete': 'yes',
                        'mod': 'number'
                    },
                    'name': 'number',
                    'attrs': {'id': 'id2482224'},
                    'js': {
                        'dataprovider': {
                            'url': '/suggests/livemap/livebus/number/',
                        },
                        'debounceDelay': 100,
                        'popupMods': {'minwidth': 'small'}
                    },
                    'content': [
                        {
                            'elem': 'label',
                            'content': {
                                'tag': 'strong',
                                'content': gettext('Искать автобусики:')
                            },
                        },
                        {'elem': 'hint', 'content': gettext(u'введите номер рейса')},
                        {'elem': 'input', 'clear': {'elem': 'clear'}}
                    ]
                },
                {
                    'elem': 'line',
                    'content': {
                        'block': 'b-form-input',
                        'mods': {
                            'size': 'm',
                            'theme': 'grey',
                            'has-clear': 'yes',
                            'autocomplete': 'yes',
                            'mod': 'station'
                        },
                        'name': 'station',
                        'attrs': {'id': 'id2482261'},
                        'js': {
                            'dataprovider': {
                                'url': '/suggests/livemap/livebus/station/',
                            },
                            'debounceDelay': 100,
                            'popupMods': {'minwidth': 'small'}
                        },
                        'content': [
                            {'elem': 'label', 'content': gettext('или')},
                            {'elem': 'hint', 'content': gettext('выберите станцию')},
                            {'elem': 'input', 'clear': {'elem': 'clear'}}
                        ]
                    }
                },
                {
                    'elem': 'line',
                    'content': {
                        'block': 'b-form-input',
                        'mods': {
                            'size': 'm',
                            'theme': 'grey',
                            'has-clear': 'yes',
                            'autocomplete': 'yes',
                            'mod': 'city'
                        },
                        'name': 'city',
                        'attrs': {'id': 'id2482297'},
                        'js': {
                            'dataprovider': {
                                'url': '/suggests/livemap/livebus/city/',
                            },
                            'debounceDelay': 100,
                            'popupMods': {'minwidth': 'small'}
                        },
                        'content': [
                            {'elem': 'label', 'content': gettext('или')},
                            {'elem': 'hint', 'content': gettext('выберите город')},
                            {'elem': 'input', 'clear': {'elem': 'clear'}}
                        ]
                    }
                },
                {
                    'elem': 'button',
                    'content': {
                        'block': 'b-form-button',
                        'mods': {'size': 'm', 'theme': 'grey-m'},
                        'type': 'submit',
                        'content': gettext('Найти автобусики')
                    }
                }
            ]
        }

