# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext

from travel.rasp.morda.morda.templates.base import Base

class Template(Base):
    page = 'maps-big'

    def __init__(self, *args, **kwargs):
        super(Template, self).__init__(*args, **kwargs)
        self.context['title'] = gettext('Самолётики')

    def page_mods(self):
        return { 'type': 'maps-big' }

    def head_content_extended(self):
        return [
            self.maps_api_js_elem()
        ]

    def content(self):
        return [
            {
                'block': 'b-map',
                'mods': { 'type': 'airplanes', 'size': 'big' },
                'js': True
            },
            # FIXIT: ПЛОХОЙ КОД: эти кнопки не отображаются и не нужны
            {
                'block': 'b-maps-search',
                'mods': { 'type': 'airplanes' },
                'cls': 'i-hidden',
                'js': { 'center': self.context.map.center,
                        'zoom': self.context.map.zoom },
                'attrs': { 'action': '#', 'method': 'get' },
                'content': [
                    {
                        'block': 'b-form-input',
                        'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'number' },
                        'name': 'number',
                        'attrs': { 'id': 'id2482224' },
                        'js': {
                            'dataprovider': { 'url': '/suggests/flights_in_air/number/' },
                            'debounceDelay': 100,
                            'popupMods': { 'minwidth': 'small' }
                        },
                        'content': [
                            { 'elem': 'label', 'content': '<strong>Искать самолётики:</strong>' },
                            { 'elem': 'hint', 'content': gettext('введите номер рейса') },
                            { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                        ]
                    },
                    {
                        'elem': 'line',
                        'content': {
                            'block': 'b-form-input',
                            'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'company' },
                            'name': 'company',
                            'attrs': { 'id': 'id2482261' },
                            'js': {
                                'dataprovider': { 'url': '/suggests/flights_in_air/company/' },
                                'debounceDelay': 100,
                                'popupMods': { 'minwidth': 'small' }
                            },
                            'content': [
                                { 'elem': 'label', 'content': 'или' },
                                { 'elem': 'hint', 'content': 'выберите авиакомпанию' },
                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                            ]
                        }
                    },
                    {
                        'elem': 'line',
                        'content': {
                            'block': 'b-form-input',
                            'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'airport' },
                            'name': 'airport',
                            'attrs': { 'id': 'id2482297' },
                            'js': {
                                'dataprovider': {
                                    'url': '/suggests/flights_in_air/airport/',
                                },
                                'debounceDelay': 100,
                                'popupMods': { 'minwidth': 'small' }
                            },
                            'content': [
                                { 'elem': 'label', 'content': 'или' },
                                { 'elem': 'hint', 'content': 'выберите аэропорт' },
                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                            ]
                        }
                    },
                    {
                        'elem': 'line',
                        'content': {
                            'block': 'b-form-input',
                            'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'city' },
                            'name': 'city',
                            'attrs': { 'id': 'id2482333' },
                            'js': {
                                'dataprovider': {
                                    'url': '/suggests/flights_in_air/city/',
                                },
                                'debounceDelay': 100,
                                'popupMods': { 'minwidth': 'small' }
                            },
                            'content': [
                                { 'elem': 'label', 'content': 'или' },
                                { 'elem': 'hint', 'content': 'выберите город' },
                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                            ]
                        }
                    },
                    {
                        'elem': 'button',
                        'content': {
                            'block': 'b-form-button',
                            'mods': { 'size': 'm', 'theme': 'grey-m' },
                            'type': 'submit',
                            'content': gettext('Найти самолётики')
                        }
                    }
                ]
            }
        ]

    def page_content(self):
        return [
            self.content(),
            self.b_mooa()
        ]
