# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext

from travel.rasp.morda.morda.templates.base import Base
from travel.rasp.morda.morda.templates.error import ErrorTemplate


def bad_link_error(request):
    return ErrorTemplate.render(
        request,
        {},
        [gettext(u'Неверная ссылка. Пожалуйста, вернитесь на предыдущую страницу и попробуйте еще раз')]
    )


class PartnerRedirectError(Base):
    page = 'search'

    def page_title(self):
        return gettext('Ошибка при переходе к партнеру')

    def content(self):
        return {
            'block': 'l-page',
            'mods': {'layout': '72-20', 'row': 'multiple'},
            'content': [
                {
                    'elem': 'row',
                    'content': [
                        {'elem': 'gap'},
                        {
                            'elem': 'left',
                            'content': [
                                {
                                    'block': 'b-page-title',
                                    'content': {
                                        'elem': 'title',
                                        'content': gettext('Ошибка при переходе к партнеру')
                                    }
                                },
                            ]
                        },
                        {'elem': 'gap-right'},
                        {'elem': 'right'},
                        {'elem': 'gap'}
                    ]
                },
                {
                    'elem': 'row',
                    'content': [
                        {'elem': 'gap'},
                        {
                            'elem': 'left',
                            'content': {
                                'block': 'b-static-text',
                                'content': {
                                    'tag': 'p',
                                    'content': gettext('К сожалению, переход к партнёру завершился неудачей. Мы обязательно попробуем выяснить у партнёра причину ошибки, а вам рекомендуем попробовать ещё раз.')
                                }
                            }
                        },
                        {'elem': 'gap-right'},
                        {
                            'elem': 'right',
                            'content': [
                                self.teaser('ahtung')
                            ]
                        },
                        {'elem': 'gap'},
                    ]
                }
            ]
        }
