# -*-  coding: utf-8 -*-

from __future__ import unicode_literals

from common.utils.bemhtml import punctuate_content
from common.utils.date import human_date_with_time, DateTimeFormatter, human_duration, astimezone
from common.utils.text import mdash_nowrap
from common.xgettext.i18n import gettext, xgettext

from travel.rasp.morda.morda.templates.base import Base
from travel.rasp.morda.morda.templates.small_description import SmallDescription, PriceDisclaimer
from travel.rasp.morda.morda.templates.utils import segment_company


class Template(Base):
    page = 'ticket'

    def option(self, option):
        return {
            'block': 'b-pricetable',
            'elem': 'row',
            'mods': {'state': 'current'},
            'content': [
                {
                    'elem': 'cell',
                    'elemMods': {'type': 'logo'},
                    'content': {
                        'elem': 'logo',
                        'src': option.logo_image.url,
                        'width': option.logo_image.width,
                        'height': option.logo_image.height,
                        'alt': ''
                    } if option.logo_image else {
                        'elem': 'logo',
                        'src': self.static_url('i/suppliers/%s.png' % option.logo),
                        'alt': ''
                    }
                },
                {
                    'elem': 'cell',
                    'content': [
                        {
                            'block': 'b-spin',
                            'mods': {'size': '10', 'theme': 'white-10', 'progress': 'yes'},
                        } if option.status == 'timeout' else {
                            'elem': 'price',
                            'content': self.b_currency(option.tariff, show_cents=False, from_=option.is_min_price)
                        }
                    ]
                },
                {
                    'block': 'b-pricetable-summ',
                    'elem': 'cell',
                    'content': {
                        'block': 'b-form-button',
                        'mods': {'size': 'xl', 'theme': 'grey-xl'},
                        'js': {'click': option.get('click')},
                        'type': 'submit',
                        'content': gettext('Купить'),
                        'name': 'choice',
                        'value': option.choice or None,
                        'attrs': {
                            'onmousedown': ';'.join((self.metrika_reach_goal("order_buy_button_click", {'partner': option.partner}),
                                                     self.metrika_reach_goal('redirect_to_partner')))
                        }
                    } if option.choice else None
                }
            ]
        }

    def content(self):
        segment = self.context.segment

        segment_link = hasattr(segment, 'link') and segment.link()

        user_tz_departure = astimezone(segment.departure, self.context['time_zone'])

        mods = {'type': 'bus'}

        if not self.context.complete:
            mods['incomplete'] = 'yes'

        options = self.context.options

        return [
            {
                'block': 'l-page',
                'mods': {'layout': '72-20', 'row': 'multiple'},
                'content': [
                    {
                        'elem': 'row',
                        'content': [
                            {'elem': 'gap'},
                            {
                                'elem': 'left',
                                'content': [
                                    {
                                        'block': 'b-page-title',
                                        'content': [
                                            {
                                                'elem': 'title',
                                                'content': self.context.page_title
                                            }
                                        ]
                                    }
                                ]
                            },
                            {'elem': 'gap-right'},
                            {
                                'elem': 'right',
                                'content': [
                                    self.b_metalinks()
                                ]
                            },
                            {'elem': 'gap'}
                        ]
                    },
                    {
                        'elem': 'row',
                        'content': [
                            {'elem': 'gap'},
                            {
                                'elem': 'left',
                                'content': [
                                    {
                                        'block': 'b-menu-horiz',
                                        'js': False,
                                        'mods': {'layout': 'complex', 'preset': 'price-links'},
                                        'content': [
                                            {
                                                'elem': 'item',
                                                'content': ''
                                            },
                                            {
                                                'elem': 'gap'
                                            },
                                            {
                                                'elem': 'item',
                                                'elemMods': {'type': 'bottom'},
                                                'content': gettext('местное время')
                                            }
                                        ]
                                    },
                                    {
                                        'block': 'b-roundtable',
                                        'content': {
                                            'block': 'b-triptable',
                                            'content': [
                                                {
                                                    'elem': 'row',
                                                    'content': {
                                                        'elem': 'cell',
                                                        'attrs': {'colspan': '4'},
                                                        'content': {
                                                            'elem': 'title',
                                                            'content': [
                                                                mdash_nowrap(segment.L_title()),
                                                                getattr(segment, 'route', None) and segment.route.title_special and [
                                                                    ', ',
                                                                    {
                                                                        'elem': 'tname',
                                                                        'content': segment.route.title_special
                                                                    }
                                                                ] or ''
                                                            ]
                                                        }
                                                    }
                                                },
                                                {
                                                    'elem': 'row',
                                                    'content': [
                                                        {
                                                            'elem': 'cell',
                                                            'content': [
                                                                {
                                                                    'elem': 'desc',
                                                                    'content': punctuate_content(filter(None, [
                                                                        segment_company(segment),
                                                                        hasattr(segment, 't_model') and unicode(segment.t_model or '')]
                                                                    ))
                                                                },
                                                                {
                                                                    'elem': 'trip',
                                                                    'content': segment_link and {
                                                                        'block': 'b-link',
                                                                        'url': segment_link,
                                                                        'content': [segment.t_type.L_title().lower()]
                                                                    } or [segment.t_type.L_title().lower()]
                                                                }
                                                            ]
                                                        },
                                                        {
                                                            'elem': 'cell',
                                                            'content': [
                                                                {
                                                                    'elem': 'desc',
                                                                    'content': segment.station_from.L_title()
                                                                },
                                                                {
                                                                    'elem': 'time',
                                                                    'content': human_date_with_time(astimezone(segment.departure, segment.station_from))
                                                                }
                                                            ]
                                                        },
                                                        {
                                                            'elem': 'cell',
                                                            'content': [
                                                                {
                                                                    'elem': 'desc',
                                                                    'content': segment.station_to.L_title()
                                                                },
                                                                {
                                                                    'elem': 'time',
                                                                    'content': human_date_with_time(astimezone(segment.arrival, segment.station_to))
                                                                }
                                                            ]
                                                        },
                                                        {
                                                            'elem': 'cell',
                                                            'content': [
                                                                {
                                                                    'elem': 'desc',
                                                                    'content': gettext('в пути')
                                                                },
                                                                {
                                                                    'elem': 'time',
                                                                    'content': human_duration(segment.duration)
                                                                }
                                                            ]
                                                        }
                                                    ]
                                                }
                                            ]
                                        }
                                    },

                                    self.context.error_message and {
                                        'block': 'b-500',
                                        'content': self.context.error_message
                                    } or options and [
                                        {
                                            'block': 'b-subtitle',
                                            'content': {
                                                'elem': 'title',
                                                'content': self.ticket_price_phrase()
                                            }
                                        },
                                        {
                                            'block': 'b-menu-horiz',
                                            'js': False,
                                            'mods': {'layout': 'complex', 'preset': 'price-links'},
                                            'content': [
                                                {
                                                    'elem': 'item',
                                                    'content': xgettext('<date format="%d %B"/> для 1 взрослого',
                                                                        date=DateTimeFormatter(user_tz_departure).L)
                                                },
                                                {
                                                    'elem': 'gap'
                                                },
                                                {
                                                    'elem': 'item',
                                                    'content': ''
                                                }
                                            ]
                                        },
                                        {
                                            'block': 'b-form',
                                            'tag': 'div',
                                            'mods': {'type': 'order'},
                                            'attrs': {'action': '/buy/bus/redirect/', 'method': 'get', 'target': '_blank'},
                                            'content': [
                                                self.context.order_form.as_hidden(),
                                                {
                                                    'block': 'b-roundtable',
                                                    'content': [
                                                        {
                                                            'block': 'b-pricetable',
                                                            'mods': mods,
                                                            'js': True,
                                                            'content': [self.option(option) for option in options]
                                                        }
                                                    ]
                                                }
                                            ]
                                        }
                                    ] or '',

                                    self.description(any(option.status != 'timeout' for option in options)),
                                ]
                            },
                            {'elem': 'gap-right'},
                            {
                                'elem': 'right',
                                'content': self.b_calendar()
                            },
                            {'elem': 'gap'}
                        ]
                    }
                ]
            }
        ]

    def description(self, options_available):
        description = SmallDescription(self)

        description.add_item_currency_disclaimer(t_type=self.context.segment.t_type.code, page='buy')

        description.items.append(PriceDisclaimer(options_available, self.context.request.NATIONAL_VERSION))

        return description

    def ticket_price_phrase(self):
        if self.context.segment.t_type.code == 'train':
            return xgettext('Цена билетов на поезд <direction-title/>', direction_title=self.context.direction_title)

        return xgettext('Цена билетов на автобус <direction-title/>', direction_title=self.context.direction_title)
