# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.xgettext.i18n import gettext

# Шаблоны
from travel.rasp.morda.morda.templates.base import Base

from travel.rasp.morda.morda.templates.print_schedule.hyphenize import hyphenize


class Template(Base):
    page = 'schedule-print-result'

    def page_attrs(self):
        return { 'onload': 'window.setTimeout(function(){window.print()}, 100)' }

    def page_title(self):
        return gettext('Расписание электричек на&nbsp;Яндекс.Расписаниях')

    def schedule_rows(self, fr, to, table):
        if len(table) == 0:
            return gettext('К сожалению, у&nbsp;Яндекс.Расписаний нет данных о&nbsp;пригородных поездах между указанными станциями.')

        return [
            {
                'elem': 'row',
                'elemMods': { 'head': 'yes' },
                'content': [
                    {
                        'elem': 'cell',
                        'content': ''
                    },
                    [
                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'title' },
                            'content': hyphenize(s.L_short_title_with_prefix())
                        }
                        for s in fr
                    ],
                    {
                        'elem': 'cell',
                        'content': ''
                    },
                    [
                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'title' },
                            'content': hyphenize(s.L_short_title_with_prefix())
                        }
                        for s in to
                    ],
                ]
            },
            [
                {
                    'elem': 'row',
                    'content': [
                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'desc' },
                            'content': text
                        },
                        [
                            {
                                'elem': 'cell',
                                'elemMods': { 'type': 'time' },
                                'content': [
                                    d.time,
                                    d.l_platform and {
                                        'block': 'b-sch-print',
                                        'elem': 'station',
                                        'content': d.l_platform
                                    } or ''
                                ]
                            }
                            for d in departures
                        ],
                        express and {
                            'elem': 'cell',
                            'elemMods': { 'type': 'express' },
                            'content': { 'block': 'b-icon', 'url': self.static_url('blocks-desktop/b-icon/_type/b-icon_type_sch-express.png'), 'alt': 'express', 'mods': { 'type': 'sch-express-result'} }
                        } or {
                            'elem': 'cell',
                            'elemMods': { 'type': 'sep' },
                            'content': '&mdash;'
                        },
                        [
                            {
                                'elem': 'cell',
                                'elemMods': { 'type': 'time' },
                                'content': [
                                    d.time,
                                    d.l_platform and {
                                        'block': 'b-sch-print',
                                        'elem': 'station',
                                        'content': d.l_platform
                                    } or ''
                                ]
                            }
                            for d in arrivals
                        ]
                    ]
                }
                for text, departures, express, arrivals in table
            ]
        ]

    def page_content(self):
        lang = get_language()

        return {
        'block': 'b-sch-print',
        'mods': { 'padding': 'yes' },
        'content': [
            {
                'elem': 'layout',
                'elemMods': { 'preset': 'print' },
                'content': [
                    {
                        'elem': 'row',
                        'content': [
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'l' },
                                'content': {
                                    'elem': 'head',
                                    'content': { 'block': 'b-icon', 'url': self.static_url('blocks-desktop/b-sch-print/__head/print_to_%s.png' % lang) }
                                }
                            },
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'sep' },
                                'content': ''
                            },
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'r' },
                                'content': {
                                    'elem': 'head',
                                    'content': { 'block': 'b-icon', 'url': self.static_url('blocks-desktop/b-sch-print/__head/print_from_%s.png' % lang) }
                                }
                            }
                        ]
                    },
                    {
                        'elem': 'row',
                        'content': [
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'l' },
                                'content': {
                                    'block': 'b-layout-table',
                                    'mods': { 'layout': 'schedule-print'},
                                    'content': self.schedule_rows(self.context.stations_from, self.context.stations_to, self.context.table_forward)
                                }
                            },
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'sep' },
                                'content': ''
                            },
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'r' },
                                'content': {
                                    'block': 'b-layout-table',
                                    'mods': { 'layout': 'schedule-print'},
                                    'content': self.schedule_rows(reversed(self.context.stations_to), reversed(self.context.stations_from), self.context.table_backward)
                                }
                            }
                        ]
                    },
                    {
                        'elem': 'row',
                        'elemMods': { 'pos': 'last' },
                        'content': [
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'l' },
                                'content': [
                                    self.context.plan_disclaimer and {
                                        'elem': 'text',
                                        'content': self.context.plan_disclaimer
                                    } or '',
                                    {
                                        'elem': 'text',
                                        'content': gettext('время местное')
                                    },
                                    self.context.expresses and {
                                        'elem': 'text',
                                        'content': [
                                            { 'block': 'b-icon', 'url': self.static_url('blocks-desktop/b-icon/_type/b-icon_type_sch-express.png'), 'alt': 'express', 'mods': { 'type': 'sch-express-result'} },
                                            '&nbsp;&ndash;&nbsp;' , gettext('экспресс')
                                        ]
                                    } or ''
                                ]
                            },
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'sep' },
                                'content': ''
                            },
                            {
                                'elem': 'col',
                                'elemMods': { 'pos': 'r' },
                                'content': [
                                    {
                                        'elem': 'logo',
                                        'content': { 'block': 'b-icon', 'url': self.static_url('i/small_logo_%s.png' % lang), 'alt': gettext('Яндекс расписания') }
                                    },
                                    {
                                        'elem': 'text',
                                        'content': [
                                            {
                                                'block': 'b-icon',
                                                'mods': { 'type': 'service-ico' },
                                                'url': self.ico_url(),
                                                'alt': gettext('расписания')
                                            },
                                            gettext('Мобильное расписание — m.rasp.yandex.ru')
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ]
    }
