# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.utils.bemhtml import loop_over
from common.utils.date import DateTimeFormatter
from common.xgettext.i18n import gettext, xgettext, xformat

# Шаблоны
from travel.rasp.morda.morda.templates.base import Base


class Template(Base):
    page = 'schedule-print-settings'
    show_search_form = False
    show_awaps = False

    def page_title(self):
        return gettext('Печать расписаний электричек')

    def content(self):

        def city_name(case='nominative'):
            return {
                'block': 'b-text',
                'mods': { 'mod': 'city-name' },
                'tag': 'span',
                'content': self.context.current_zone.settlement.L_title(case)
            }

        return [
            {
                'block': 'l-page',
                'mods': { 'layout': '16-80' },
                'content': {
                    'elem': 'row',
                    'content': [
                        { 'elem': 'gap' },
                        {
                            'elem': 'left',
                            'content': {
                                'elem': 'left-i',
                                'content': ''
                            }
                        },
                        {
                            'elem': 'right',
                            'content': [
                                {
                                    'block': 'b-page-title',
                                    'content': [
                                        {
                                            'elem': 'title',
                                            'content': xformat(
                                                'Печать расписания электричек <city-name case="genitive"/>',
                                                city_name=city_name
                                            ) if get_language() == 'ru' else (
                                                # Печать расписания электричек: Москва
                                                xgettext('Печать расписания электричек: <city-name/>', city_name=city_name)
                                            )
                                        },
                                        ' &nbsp;',
                                        self.b_other_cities(case='genitive' if get_language() == 'ru' else 'nominative')
                                    ]
                                },
                                {
                                    'block': 'b-static-text',
                                    'content': gettext('<p>Вы можете распечатать расписание между выбранными вами станциями. Можно выбирать до&#0160;трёх станций отправлений и&#0160;до&#0160;трёх станций прибытия.</p>')
                                },
                                {
                                    'block': 'b-sch-print',
                                    'js': { 'zone_id': self.context.current_zone.id },
                                    'content': [
                                        {
                                            'elem': 'tabs',
                                            'mix': [{ 'block': 'i-clearfix' }],
                                            'content': [
                                                {
                                                    'elem': 'tab',
                                                    'elemMods': { 'state': 'current' } if not self.context.next_plan else {},
                                                    'content': { 'block': 'b-link', 'mods': { 'pseudo': 'yes' }, 'content': gettext('текущее расписание') }
                                                },
                                                self.context.next_plan and {
                                                    'elem': 'tab',
                                                    'elemMods': { 'state': 'current' },
                                                    'js': { 'next_plan': True },
                                                    'content': {
                                                        'block': 'b-link',
                                                        'mods': { 'pseudo': 'yes' },
                                                        'content': xgettext('после смены графика (с&nbsp;<date format="%d %B"/>)',
                                                                            date=DateTimeFormatter(self.context.next_plan.start_date).L,
                                                                            nbsp='&nbsp;')
                                                    }
                                                } or ''
                                            ]
                                        },
                                        {
                                            'elem': 'pane',
                                            'content': [
                                                { 'elem': 'text', 'content': gettext('Выберите нужное вам направление') },
                                                {
                                                    'elem': 'trips',
                                                    'content': [
                                                        [
                                                            not loop.first and ' ' or '',
                                                            {
                                                                'elem': 'trip',
                                                                'elemMods': loop.first and { 'state': 'current' } or {},
                                                                'js': { 'id': d.id },
                                                                'content': [
                                                                    {
                                                                        'block': 'b-link',
                                                                        'mods': { 'pseudo': 'yes' },
                                                                        'url': '#',
                                                                        'content': d.L_title()
                                                                    },
                                                                    { 'elem': '3pt', 'tag':'span', 'content': ',' }
                                                                ]
                                                            }
                                                        ]
                                                        for loop, d in loop_over(self.context.directions)
                                                    ] + [
                                                        {
                                                            'elem': 'trip',
                                                            'js': { 'id': '' },
                                                            'content': { 'block': 'b-link', 'mods': { 'pseudo': 'yes' }, 'url': '#', 'content': gettext('все направления') }
                                                        }
                                                    ]
                                                },
                                                {
                                                    'elem': 'text',
                                                    'content': [
                                                        {
                                                            'block': 'b-form-radio',
                                                            'mods': { 'size': 'm', 'theme': 'grey', 'mod': 'reversed' },
                                                            'inputAttrs': { 'name': 'reverse' },
                                                            'content': [
                                                                {
                                                                    'elem': 'button',
                                                                    'elemMods': { 'checked': 'yes' },
                                                                    'inputAttrs': { 'value': 'false' },
                                                                    'content': gettext('В область')
                                                                },
                                                                {
                                                                    'elem': 'button',
                                                                    'inputAttrs': { 'value': 'true' },
                                                                    'content': gettext('Из области')
                                                                }
                                                            ]
                                                        }
                                                    ]
                                                },
                                                {
                                                    'elem': 'text',
                                                    'content': gettext('Выберите станции отправления')
                                                },
                                                {
                                                    'elem': 'layout',
                                                    'content': [
                                                        {
                                                            'elem': 'row',
                                                            'content': [
                                                                {
                                                                    'elem': 'col',
                                                                    'content': {
                                                                        'elem': 'multiple',
                                                                        'elemMods': { 'mod': 'stations-from' },
                                                                        'content': [
                                                                            {
                                                                                'elem': 'multiple-option',
                                                                                'value': s.id,
                                                                                'content': s.L_title(),
                                                                                'js': { 'order': loop.index }
                                                                            }
                                                                            for loop, s in loop_over(self.context.stations)
                                                                        ]
                                                                    }
                                                                },
                                                                {
                                                                    'elem': 'col-arrow',
                                                                    'content': [
                                                                        {
                                                                            'elem': 'arrow',
                                                                            'elemMods': { 'type': 'right-disabled', 'mod': 'from-add' }
                                                                        },
                                                                        {
                                                                            'elem': 'arrow',
                                                                            'elemMods': { 'type': 'left-disabled', 'mod': 'from-remove' }
                                                                        }
                                                                    ]
                                                                },
                                                                {
                                                                    'elem': 'col',
                                                                    'content': {
                                                                        'elem': 'multiple',
                                                                        'elemMods': { 'mod': 'stations-from-selected' },
                                                                        'content': []
                                                                    }
                                                                }

                                                            ]
                                                        }
                                                    ]
                                                },
                                                {
                                                    'elem': 'text',
                                                    'content': gettext('Выберите станции прибытия')
                                                },
                                                {
                                                    'elem': 'layout',
                                                    'content': [
                                                        {
                                                            'elem': 'row',
                                                            'content': [
                                                                {
                                                                    'elem': 'col',
                                                                    'content': {
                                                                        'elem': 'multiple',
                                                                        'elemMods': { 'mod': 'stations-to' },
                                                                        'content': [
                                                                            {
                                                                                'elem': 'multiple-option',
                                                                                'value': s.id,
                                                                                'content': s.L_title(),
                                                                                'js': { 'order': loop.index }
                                                                            }
                                                                            for loop, s in loop_over(self.context.stations)
                                                                        ]
                                                                    }
                                                                },
                                                                {
                                                                    'elem': 'col-arrow',
                                                                    'content': [
                                                                        {
                                                                            'elem': 'arrow',
                                                                            'elemMods': { 'type': 'right-disabled', 'mod': 'to-add' }
                                                                        },
                                                                        {
                                                                            'elem': 'arrow',
                                                                            'elemMods': { 'type': 'left-disabled', 'mod': 'to-remove' }
                                                                        }
                                                                    ]
                                                                },
                                                                {
                                                                    'elem': 'col',
                                                                    'content': {
                                                                        'elem': 'multiple',
                                                                        'elemMods': { 'mod': 'stations-to-selected' },
                                                                        'content': []
                                                                    }
                                                                }

                                                            ]
                                                        }
                                                    ]
                                                },
                                                {
                                                    'elem': 'submit',
                                                    'elemMods': { 'disabled': 'yes', 'lang': get_language() }
                                                }
                                            ]
                                        }
                                    ]
                                }
                            ]
                        },
                        { 'elem': 'gap' }
                    ]
                }
            }
        ]

    def b_other_cities(self, case):
        return {
            'block': 'b-dropdowna',
            'mods': { 'color': 'black' },
            'content': [
                {
                    'elem': 'switcher',
                    'content': {
                        'block': 'b-link',
                        'mods': { 'pseudo': 'yes' },
                        'content': gettext('другие&#0160;города')
                    }
                },
                {
                    'block': 'b-popupa',
                    'mods': {
                        'theme': 'ffffff',
                        'direction': 'down'
                    },
                    'content': [
                        { 'elem': 'tail' },
                        {
                            'elem': 'content',
                            'elemMods': { 'scroll': 'yes' },
                            'content': {
                                'block': 'b-menu',
                                'mods': { 'layout': 'vert' },
                                'mix': [
                                    { 'block': 'b-dropdowna', 'elem': 'menu', 'elemMods': { 'color': 'black' } }
                                ],
                                'content': [
                                    {
                                        'elem': 'item',
                                        'position': loop.first and 'first' or loop.last and 'last' or '',
                                        'content': {
                                            'block': 'b-link',
                                            'mods': { 'change-params': 'yes', 'pseudo': 'yes' },
                                            'js': { 'params': { 'city': { 'id': z.id, 'title': z.settlement.L_title(case=case) }}},
                                            'url': '#',
                                            'content': z.settlement.L_title()
                                        }
                                    }
                                    for loop, z in loop_over(self.context.zones)
                                ]
                            }
                        }
                    ]
                }
            ]
        }
