# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.disclaimers import StaticText
from common.xgettext.i18n import gettext


class Item(object):
    def __init__(self, content, hidden=False):
        self.content = content
        self.hidden = hidden


class TimeIsLocal(object):
    content = gettext('время местное.')
    item = 'time-is-local'

    def __init__(self, base):
        self.hidden = base.context.time_zone is not None


class AbstractCurrencyDisclaimer(object):
    item = 'currency-disclaimer'

    def __init__(self, currency_info, currency_disclaimer_name):
        if currency_info.country_base in ['TRY', 'UAH']:
            currency_disclaimer_name += '_{}'.format(currency_info.country_base)

        self.content = StaticText.get_text_by_code(currency_disclaimer_name, source=currency_info.source)
        self.hidden = currency_info.selected == currency_info.country_base


class CurrencyDisclaimer(AbstractCurrencyDisclaimer):
    def __init__(self, currency_info, t_type):
        currency_disclaimer_name = 'currency_bus_disclaimer' if t_type == 'bus' else 'currency_disclaimer'

        super(CurrencyDisclaimer, self).__init__(currency_info, currency_disclaimer_name)


class BuyPageCurrencyDisclaimer(AbstractCurrencyDisclaimer):
    def __init__(self, currency_info, t_type):
        currency_disclaimer_name = 'currency_bus_disclaimer' if t_type == 'bus' else 'currency_disclaimer_buypage'

        super(BuyPageCurrencyDisclaimer, self).__init__(currency_info, currency_disclaimer_name)


class PriceDisclaimer(object):
    item = 'price-disclaimer'

    def __init__(self, prices_available, national_version):
        self.content = get_currency_buypage_disclaimer(national_version)
        self.hidden = not prices_available


class SmallDescription(object):
    def __init__(self, base):
        self.base = base
        self.items = []

    def add_item(self, content, hidden=False):
        self.items.append(Item(content, hidden=hidden))

    def add_item_time_is_local(self):
        self.items.append(TimeIsLocal(self.base))

    def add_item_currency_disclaimer(self, t_type='train', page='search'):
        currency_info = self.base.context.currency_info

        if currency_info:
            if page == 'search':
                disclaimer = CurrencyDisclaimer(currency_info, t_type)

            else:
                disclaimer = BuyPageCurrencyDisclaimer(currency_info, t_type)

            self.items.append(disclaimer)

    def __json__(self):
        hidden = all(item.hidden for item in self.items)

        return {
            'block': 'b-small-description',
            'mix': [hidden and { 'block': 'i-hidden' } ],
            'js': True,
            'content': [
                {
                    'elem': 'item',
                    'elemMods': { 'item': getattr(item, 'item', None) },
                    'mix': [bool(item.hidden) and { 'block': 'i-hidden'} ],
                    'content': item.content
                }
                for item in self.items
            ]
        }


def get_currency_buypage_disclaimer(national_version):
    currency_buypage_disclaimer_name = 'currency_buypage_disclaimer'

    if national_version == 'ua':
        currency_buypage_disclaimer_name += '_ua'

    return StaticText.get_text_by_code(currency_buypage_disclaimer_name)
