# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext, xgettext

# Шаблоны
from base import Template as Base


class Template(Base):
    page = 'tstation'

    def message(self):
        station = self.context.station
        t_type = station.t_type.code

        if self.context.reason == 'no_info':
            return xgettext('К сожалению, у нас нет никакой информации о станции «<popular-title/>».', popular_title=station.L_popular_title_extra)

        if t_type == 'bus':
            if station.station_type_id == 10:
                return gettext('У Яндекс.Расписаний нет сведений об автобусах, останавливающихся на&nbsp;этом автовокзале')

            else:
                return gettext('У Яндекс.Расписаний нет сведений об автобусах, останавливающихся на&nbsp;этой автобусной остановке')

        elif t_type == 'plane':
            return gettext('У Яндекс.Расписаний нет сведений о&nbsp;самолётах, прибывающих или отправляющихся из&nbsp;этого аэропорта.')

        return gettext('У Яндекс.Расписаний нет сведений о&nbsp;рейсах, останавливающихся на&nbsp;этой станции.')

    def content(self):
        return {
            'block': 'l-page',
            'mods': { 'layout': '72-20', 'row': 'multiple' },
            'content': [
                {
                    'elem': 'row',
                    'content': [
                        {
                            'elem': 'gap'
                        },
                        {
                            'elem': 'left',
                            'content': {
                                'block': 'b-page-title',
                                'content': [
                                    {
                                        'elem': 'title',
                                        'content': self.context.page_title
                                    },
                                ]
                            }
                        },
                        {
                            'elem': 'gap-right'
                        },
                        {
                            'elem': 'right',
                            'content': self.b_metalinks()
                        }
                    ]
                },
                {
                    'elem': 'row',
                    'content': [
                        {
                            'elem': 'gap'
                        },
                        {
                            'elem': 'left',
                            'content': [
                                {
                                    'block': 'b-tablo-triggers',
                                    'content': ''
                                },
                                {
                                    'block': 'b-static-text',
                                    'content': self.message()
                                }
                            ]
                        },
                        {
                            'elem': 'gap-right'
                        },
                        {
                            'elem': 'right',
                            'content': ''
                        }
                    ]
                }
            ]
        }
