# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.disclaimers import StaticText
from common.utils.date import DateTimeFormatter
from common.xgettext.i18n import gettext, xgettext

# Шаблоны
from travel.rasp.morda.morda.templates.station.base import Template as Base
from travel.rasp.morda.morda.utils.locations import station_thread_url


class Template(Base):
    page = 'bus-station'

    def b_block_schedule(self):
        roughly_route_time = StaticText.get_text_by_code('roughly_route_time')
        if not self.context.schedule_blocks:
            if self.context.date:
                content = xgettext('Нет информации об автобусах, отправляющихся '
                                   '<date format="%d %B"/>. '
                                   'Попробуйте посмотреть <b-link>расписание на все дни.</b-link>',
                                   date=DateTimeFormatter(self.context.date).L,
                                   b_link=lambda content: {
                                       'block': 'b-link',
                                       'url': self.station_url(span='schedule'),
                                       'content': content
                                   }
                )
            else:
                content = '&nbsp;'

            return {
                'block': 'b-station-rasp',
                'content': [
                    {
                        'elem': 'row',
                        'content': {
                            'elem': 'cell',
                            'attrs': { 'colspan': '3' },
                            'content': [
                                '<!-- noindex -->',
                                {
                                    'block': 'b-static-text',
                                    'mix': [{ 'block': 'b-notice' }],
                                    'content': content
                                },
                                '<!-- /noindex -->',
                            ]
                        }
                    }
                ]
            }

        return {
            'block': 'b-station-rasp',
            'content': [
                {
                    'elem': 'row',
                    'content': [
                        self.context.show_blocks_numbers and {
                            'elem': 'col',
                            'elemMods': { 'type': 'num' },
                            'content': { 'elem': 'text', 'content': block.number and ['№', ' ', block.number] or '' }
                        } or '',
                        {
                            'elem': 'col',
                            'elemMods': { 'type': 'name' },
                            'content': block.station_from and block.station_to and [
                                not block.station_is_first_in_route and {
                                    'elem': 'line',
                                    'content': {
                                        'elem': 'text',
                                        'elemMods': { 'color': 'gray' },
                                        'content': {
                                            'elem': 'text',
                                            'tag': 'nowrap',
                                            'content': [block.station_from, '&nbsp;&mdash;']
                                        }
                                    }
                                } or '',
                                {
                                    'elem': 'line',
                                    'content': {
                                        'elem': 'text',
                                        'elemMods': { 'bold': 'yes' },
                                        'content': block.station_to
                                    }
                                }
                            ] or [
                                {
                                    'elem': 'line',
                                    'content': {
                                        'elem': 'text',
                                        'elemMods': { 'bold': 'yes' },
                                        'content': block.title
                                    }
                                }
                            ]
                        },
                        {
                            'elem': 'col',
                            'elemMods': { 'type': 'time' },
                            'content': [
                                {
                                    'elem': 'group' if self.context.is_for_all_days else 'group_for_date',
                                    'content': [
                                        self.context.is_for_all_days and {
                                            'elem': 'day',
                                            'content': calendar.days_text
                                        } or '',
                                        {
                                            'elem': 'times',
                                            'content': [
                                                calendar.interval and [
                                                    {
                                                        'elem': 'time',
                                                        'content': [
                                                            {
                                                                'block': 'b-link',
                                                                'url': station_thread_url(
                                                                    calendar.route.thread, calendar.route.start_date,
                                                                    self.context.request
                                                                ),
                                                                'content': ['с ', calendar.interval.begin_time.strftime('%H:%M'),
                                                                            ' до ', calendar.interval.end_time.strftime('%H:%M')]
                                                            },
                                                            ' ', calendar.interval.density
                                                        ]
                                                    },
                                                    calendar.interval.comment and [
                                                        '</br>',
                                                        {
                                                            'elem': 'time',
                                                            'tag': 'div',
                                                            'content': calendar.interval.comment
                                                        }
                                                    ]
                                                ] or [
                                                    {
                                                        'elem': 'time',
                                                        'elemMods': { 'color': event.is_fuzzy and 'gray' or '' },
                                                        'content': [
                                                            {
                                                                'block': 'b-link',
                                                                'url': station_thread_url(
                                                                    event.route.thread, event.route.start_date,
                                                                    self.context.request
                                                                ),
                                                                'content': event.time.strftime('%H:%M')
                                                            },
                                                            event.is_fuzzy and {
                                                                'block': 'b-link',
                                                                'mods': { 'pseudo': 'yes', 'type': 'button' },
                                                                'js': { 'popupmessage': roughly_route_time },
                                                                'content': '?'
                                                            } or ''
                                                        ]
                                                    } for event in calendar.times
                                                ]
                                            ]
                                        }
                                    ]
                                } for calendar in block.calendars
                            ]
                        },
                        {
                            'elem': 'gap'
                        }
                    ]
                } for block in self.context.schedule_blocks
            ]
        }

    def content(self):
        station = self.context.station

        return [
            {
                'block': 'l-page',
                'mods': { 'layout': '72-20', 'row': 'multiple' },
                'content': [
                    self.content_first_row(),
                    {
                        'elem': 'row',
                        'content': [
                            {
                                'elem': 'gap'
                            },
                            {
                                'elem': 'left',
                                'content': [
                                    {
                                        'block': 'b-tablo-triggers',
                                        'content': [
                                            self.b_datelinks(),
                                            self.b_triggers(),
                                        ]
                                    },
                                    station.incomplete_bus_schedule and {
                                        'block': 'b-description-text',
                                        'content': [
                                            {
                                                'elem': 'item',
                                                'content': [
                                                    '<!-- noindex -->',
                                                    StaticText.get_text_by_code('station_incomplete_schedule_disclaimer',
                                                                                 station_title=station.L_title),
                                                    '<!-- /noindex -->'
                                                ]
                                            }
                                        ]
                                    } or '',
                                    self.b_block_schedule(),
                                    {
                                        'block': 'b-description-text',
                                        'content': [
                                            {
                                                'elem': 'item',
                                                'content': station.station_type_id == 10 and\
                                                           StaticText.get_text_by_code('autobus_schedule_disclaimer') or\
                                                           StaticText.get_text_by_code('autobus_station_schedule_disclaimer')
                                            },
#                                            {
#                                                'elem': 'item',
#                                                'content': self.b_link_place_on_my_site()
#                                            },
                                            {
                                                'elem': 'item',
                                                'content': gettext('время местное')
                                            }
                                        ]
                                    },
                                    self.context.counter and '<img src="//clck.yandex.ru/click/dtype=stred/pid=168/cid=%s/*http://ya.ru" />' % self.context.counter or ''
                                ]
                            },
                            {
                                'elem': 'gap-right'
                            },
                            {
                                'elem': 'right',
                                'content': self.right_content(),
                            },
                            {
                                'elem': 'gap'
                            }
                        ]
                    }
                ]
            }
        ]
